/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#include "bbPackRecalageCheckBoardBox.h"
#include "bbPackRecalagePackage.h"

namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,CheckBoardBox)
BBTK_BLACK_BOX_IMPLEMENTATION(CheckBoardBox,bbtk::AtomicBlackBox);
void CheckBoardBox::Process()
{
	 
// THE MAIN PROCESSING METHOD BODY 
	checkboard->setInputImage1(bbGetInputIn1());
	checkboard->setInputImage2(bbGetInputIn2());
	if(bbGetInputIn1() != NULL && bbGetInputIn2() != NULL)
	{
		checkboard->setRows(bbGetInputRows());
		checkboard->setCols(bbGetInputCols());
		checkboard->calculateImage();
		bbSetOutputOut(checkboard->getFilteredImage());	
	}
	else
	{
		bbSetOutputOut(NULL);
	}  
}
void CheckBoardBox::bbUserSetDefaultValues()
{
   bbSetInputIn1(NULL); 
   bbSetInputIn2(NULL); 
   bbSetInputRows(0); 
   bbSetInputCols(0);
   checkboard=NULL;
  
}
void CheckBoardBox::bbUserInitializeProcessing()
{
//  THE INITIALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should allocate the internal/output pointers  
//    if any 
	checkboard = new CheckBoard();
  
}
void CheckBoardBox::bbUserFinalizeProcessing()
{
	
//  THE FINALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should desallocate the internal/output pointers  
//    if any 
   //delete checkboard;	
}
}
// EO namespace bbPackVisuImages


