/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalageDuplicateImageBox_h_INCLUDED__
#define __bbPackRecalageDuplicateImageBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "iostream"

#include "vtkImageData.h"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT DuplicateImageBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(DuplicateImageBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(In,vtkImageData*);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  BBTK_PROCESS(Process);
  void Process();
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(DuplicateImageBox,bbtk::AtomicBlackBox);
BBTK_NAME("DuplicateImageBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Creates a shallow copy of its image input");
BBTK_CATEGORY("__CATEGORY__");
BBTK_INPUT(DuplicateImageBox,In,"Original Image",vtkImageData*,"");
BBTK_OUTPUT(DuplicateImageBox,Out,"Duplicated Image",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(DuplicateImageBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageDuplicateImageBox_h_INCLUDED__

