/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
#include "bbPackRecalageGridOnImageGenerator.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,GridOnImageGenerator)
BBTK_BLACK_BOX_IMPLEMENTATION(GridOnImageGenerator,bbtk::AtomicBlackBox);
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void GridOnImageGenerator::Process()
{
	std::cout << "GridOnImageGenerator" << std::endl;
	//Variables
	vtkImageData* inImage = NULL;
	vtkImageData* outputImage = NULL;
	double gridSpcX = 0, gridSpcY = 0, gridSpcZ = 0;

	//Get inputs
	inImage = bbGetInputIn();
	gridSpcX = bbGetInputGridSpcX();
	gridSpcY = bbGetInputGridSpcY();
	gridSpcZ = bbGetInputGridSpcZ();

	//Grid on image generator
	gridOnImageGenerator = new MyGridOnImageGenerator(inImage, gridSpcX, gridSpcY, gridSpcZ);

	outputImage = gridOnImageGenerator->getGridOnImage();
    bbSetOutputOut( outputImage );
    std::cout << "GridOnImageGenerator ... OK" << std::endl;
  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void GridOnImageGenerator::bbUserSetDefaultValues()
{
   bbSetInputIn(NULL);
   bbSetInputGridSpcX(0);
   bbSetInputGridSpcY(0);
   bbSetInputGridSpcZ(0);
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void GridOnImageGenerator::bbUserInitializeProcessing()
{

//  THE INITIALIZATION METHOD BODY :
//    Here does nothing 
//    but this is where you should allocate the internal/output pointers 
//    if any 

  
}
//===== 
// Before editing this file, make sure it's a file of your own (i.e.: it wasn't generated from xml description; if so : your modifications will be lost)
//===== 
void GridOnImageGenerator::bbUserFinalizeProcessing()
{

	if(gridOnImageGenerator != NULL)
		delete gridOnImageGenerator;
  
}
}
// EO namespace bbPackRecalage


