/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#include "bbPackRecalageImageRecalageProperties.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,ImageRecalageProperties)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageRecalageProperties,bbtk::AtomicBlackBox);
void ImageRecalageProperties::Process()
{
	image = bbGetInputIn();
	if(image != NULL)
	{
		bbSetOutputLengthX((int)image->GetDimensions()[0] - 1);
		bbSetOutputLengthY((int)image->GetDimensions()[1] - 1);
		bbSetOutputLengthZ((int)image->GetDimensions()[2] - 1);
		
		if(image->GetScalarType() == VTK_DOUBLE)
		{
				bbSetOutputColorLevel(50);
				bbSetOutputMidColorLevel(25);
		}
		else
		{
				bbSetOutputColorLevel(255);
				bbSetOutputMidColorLevel(127.5);
		}
	}
}
void ImageRecalageProperties::bbUserSetDefaultValues()
{ 
   bbSetInputIn(NULL);
   image = NULL;  
}
void ImageRecalageProperties::bbUserInitializeProcessing()
{
 
//  THE INITIALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should allocate the internal/output pointers  
//    if any  
 
  
}
void ImageRecalageProperties::bbUserFinalizeProcessing()
{
	image->Delete();
}
}
// EO namespace bbPackRecalage
