/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#include "bbPackRecalageImageSubstraction.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{
BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,ImageSubstraction)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageSubstraction,bbtk::AtomicBlackBox);
void ImageSubstraction::Process()
{
	subImage = new Substraction(bbGetInputIn1(),bbGetInputIn2(),bbGetInputIn3(),bbGetInputIn4(),bbGetInputInU(),bbGetInputInL(),bbGetInputInM()); 

    bbSetOutputOut(subImage->getSubstractedImage());  
}
void ImageSubstraction::bbUserSetDefaultValues()
{
	bbSetInputIn1(NULL); 
	bbSetInputIn2(NULL);
	bbSetInputIn3(0);
	bbSetInputIn4(0);
	std::vector<double> vector;	
	bbSetInputInU(vector);
	bbSetInputInM(vector);
	bbSetInputInL(vector);
	subImage = NULL;
  
}
void ImageSubstraction::bbUserInitializeProcessing()
{
 
//  THE INITIALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should allocate the internal/output pointers  
//    if any  
 
  
}
void ImageSubstraction::bbUserFinalizeProcessing()
{
	if(subImage!=NULL)
	{
		delete subImage;
	}
}
}
// EO namespace bbCreaRecalage


