/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#include "bbPackRecalageImageSwitcherBox.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{
	MyTimer::MyTimer(ImageSwitcherBox *box): wxTimer()
	{
		_box = box;		
	}

	MyTimer::~MyTimer()
	{
		//delete this;
	}

	void MyTimer::Notify()
	{
		//This will be called each time the timer finishes a countdown
		_box->Change();
		_box->bbSignalOutputModification(std::string("Out")); 
	}	

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,ImageSwitcherBox)
BBTK_BLACK_BOX_IMPLEMENTATION(ImageSwitcherBox,bbtk::WxBlackBox);

void ImageSwitcherBox::Change()
{
	//Just changes the images each time the timer finishes a countdown
	
	if(change == false)
	{
		bbSetOutputOut(bbGetInputIn2());		
		change = true;
	}
	else
	{
		bbSetOutputOut(bbGetInputIn1());
		change = false;
	}	
}

void ImageSwitcherBox::Process()
{
	time = bbGetInputTime();
	_on =  bbGetInputOn();

	if(firstTime == true)
	{
		firstTime = false;			
		if(bbGetInputIn1() != NULL)
		{
			bbSetOutputOut(bbGetInputIn1());
		} else if(bbGetInputIn2() != NULL) {
			bbSetOutputOut(bbGetInputIn2());
		}
	}

	if(myTimer == NULL)
	{
		myTimer = new MyTimer(this);
		myTimer->Start(time);
		oldTime = time;
	}
	
	if(!_on)
	{
		myTimer->Stop();
	} else if(!myTimer->IsRunning()) {
		myTimer->Start(time);
		oldTime = time;
	} else if(oldTime != time) {
		myTimer->Stop();
		myTimer->Start(time);
		oldTime=time;
	}
}


void ImageSwitcherBox::CreateWidget(wxWindow* parent)
{
	//Creates a simple text widget because it is necesary that a non-empty widget exists for creatingh the thread of the timer.
	bbSetOutputWidget( new wxStaticText(parent, -1, _T("Image Switcher")) );	
}


void ImageSwitcherBox::bbUserSetDefaultValues()
{
	myTimer 	= NULL;
	change 		= false;
	time 		= 500;
	oldTime 	= 500;
	firstTime 	= true;
	_on		= false;
}
void ImageSwitcherBox::bbUserInitializeProcessing()
{
}

void ImageSwitcherBox::bbUserFinalizeProcessing()
{
	myTimer->Stop();
	delete myTimer;
}

} // EO namespace bbPackRecalage

