/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifdef _USE_WXWIDGETS_
#ifndef __bbPackRecalageImageSwitcherBox_h_INCLUDED__
#define __bbPackRecalageImageSwitcherBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkWxBlackBox.h"

#include "vtkImageData.h"

#include <wx/timer.h>
#include <wx/wx.h>

namespace bbPackRecalage
{
	class ImageSwitcherBox;

	class MyTimer: public wxTimer
	{
	public:
		MyTimer(ImageSwitcherBox *box);
		~MyTimer();
	virtual void Notify();

	ImageSwitcherBox *_box;
	};

class bbPackRecalage_EXPORT ImageSwitcherBox
 : 
   public bbtk::WxBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(ImageSwitcherBox,bbtk::WxBlackBox);
  BBTK_DECLARE_INPUT(Title,std::string);
  BBTK_DECLARE_INPUT(In1,vtkImageData*);
  BBTK_DECLARE_INPUT(In2,vtkImageData*);
  BBTK_DECLARE_INPUT(Time,int);
  BBTK_DECLARE_INPUT(On,bool);
  BBTK_PROCESS(Process);
  BBTK_DECLARE_OUTPUT(Out,vtkImageData*);
  void Process();
  BBTK_CREATE_WIDGET(CreateWidget);
  void CreateWidget(wxWindow*);

  public:
	  void Change();

  private:
	bool change;
	MyTimer *myTimer;
	int time;
	int oldTime;
	bool _on;
	bool firstTime;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(ImageSwitcherBox,bbtk::WxBlackBox);
BBTK_NAME("ImageSwitcherBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Switches between 2 images for comparison");
BBTK_CATEGORY("__CategoryBlackBox__");
BBTK_INPUT(ImageSwitcherBox,Title,"Title prepended to the Widget",std::string,"");
BBTK_INPUT(ImageSwitcherBox,In1,"First Image",vtkImageData*,"");
BBTK_INPUT(ImageSwitcherBox,In2,"Second Image",vtkImageData*,"");
BBTK_INPUT(ImageSwitcherBox,Time,"Time between image change",int,"");
BBTK_INPUT(ImageSwitcherBox,On,"Defines if the switcher is turned on. ON = True.",bool,"");
BBTK_OUTPUT(ImageSwitcherBox,Out,"Image to be placed",vtkImageData*,"");
BBTK_END_DESCRIBE_BLACK_BOX(ImageSwitcherBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalageImageSwitcherBox_h_INCLUDED__
#endif // _USE_WXWIDGETS_

