/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#ifndef __bbPackRecalagePlaneReorientationBox_h_INCLUDED__
#define __bbPackRecalagePlaneReorientationBox_h_INCLUDED__
#include "bbPackRecalage_EXPORT.h"
#include "bbtkAtomicBlackBox.h"
#include "vtkTransform.h"
#include "vtkMath.h"
#include "vtkMatrix4x4.h"
#include "PlaneReorientation.h"
#include <string>

#include "iostream"

namespace bbPackRecalage
{

class bbPackRecalage_EXPORT PlaneReorientationBox
 : 
   public bbtk::AtomicBlackBox
{
  BBTK_BLACK_BOX_INTERFACE(PlaneReorientationBox,bbtk::AtomicBlackBox);
  BBTK_DECLARE_INPUT(InX,std::vector<int>);
  BBTK_DECLARE_INPUT(InY,std::vector<int>);
  BBTK_DECLARE_INPUT(InZ,std::vector<int>);
  BBTK_DECLARE_INPUT(labels,std::vector<std::string>);
  BBTK_DECLARE_INPUT(CenterPoint,std::vector<int>);
  BBTK_DECLARE_OUTPUT(Out,vtkTransform*);
  BBTK_PROCESS(Process);
  void Process();

  private:
	  vtkTransform *transform;
};

BBTK_BEGIN_DESCRIBE_BLACK_BOX(PlaneReorientationBox,bbtk::AtomicBlackBox);
BBTK_NAME("PlaneReorientationBox");
BBTK_AUTHOR("jn.trillos44@uniandes.edu.co");
BBTK_DESCRIPTION("Reorientates an image by use of a plane");
BBTK_CATEGORY("filter");
BBTK_INPUT(PlaneReorientationBox,InX,"Points in X (for all the three points)",std::vector<int>,"");
BBTK_INPUT(PlaneReorientationBox,InY,"Points in Y (for all the three points)",std::vector<int>,"");
BBTK_INPUT(PlaneReorientationBox,InZ,"Points in Z (for all the three points)",std::vector<int>,"");
BBTK_INPUT(PlaneReorientationBox,labels,"Labels of the points",std::vector<std::string>,"");
BBTK_INPUT(PlaneReorientationBox,CenterPoint,"CenterPoint",std::vector<int>,"");
BBTK_OUTPUT(PlaneReorientationBox,Out,"Transformation ",vtkTransform*,"");
BBTK_END_DESCRIBE_BLACK_BOX(PlaneReorientationBox);
}
// EO namespace bbPackRecalage

#endif // __bbPackRecalagePlaneNormalBox_h_INCLUDED__

