/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#include "bbPackRecalageReSlicerBox.h"
#include "bbPackRecalagePackage.h"

namespace bbPackRecalage
{


//-----------------------------------------------------------------------------
void ReSlicerBox::GetBackInfo(double *backInfo, vtkMatrix4x4 *vtkmatrix, std::vector<int> point )
{

		backInfo[0]=vtkmatrix->GetElement(0,0);
		backInfo[1]=vtkmatrix->GetElement(0,1);
		backInfo[2]=vtkmatrix->GetElement(0,2);
		backInfo[3]=vtkmatrix->GetElement(0,3);
		backInfo[4]=vtkmatrix->GetElement(1,0);
		backInfo[5]=vtkmatrix->GetElement(1,1);
		backInfo[6]=vtkmatrix->GetElement(1,2);
		backInfo[7]=vtkmatrix->GetElement(1,3);
		backInfo[8]=vtkmatrix->GetElement(2,0);
		backInfo[9]=vtkmatrix->GetElement(2,1);
		backInfo[10]=vtkmatrix->GetElement(2,2);
		backInfo[11]=vtkmatrix->GetElement(2,3);
		backInfo[12]=vtkmatrix->GetElement(3,0);
		backInfo[13]=vtkmatrix->GetElement(3,1);
		backInfo[14]=vtkmatrix->GetElement(3,2);
		backInfo[15]=vtkmatrix->GetElement(3,3);

		backInfo[16]=-point[0];
		backInfo[17]=-point[1];;
		backInfo[18]=-point[2];;
}

//-----------------------------------------------------------------------------
bool ReSlicerBox::CompareBackInfo(double* backInfoA, double * backInfoB)
{
	bool ok=true;
	int i;
	for (i=0; i<sizeBackInfo; i++ )
	{
           if (backInfoA[i]!=backInfoB[i])
	   {
		ok=false;
	   } // if
	} //for
	return ok;
}


//-----------------------------------------------------------------------------
BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,ReSlicerBox)
BBTK_BLACK_BOX_IMPLEMENTATION(ReSlicerBox,bbtk::AtomicBlackBox);
void ReSlicerBox::Process()
{
	if(!bbGetInputOrigin().empty()  && bbGetInputTransform() != NULL)
	{
		//image = vtkImageChangeInformation::New();
		image->SetInput( bbGetInputIn() );
		image->SetOutputSpacing( 1,1,1 );

		if(bbGetInputCentered())
		{
			image->CenterImageOn();
		}

                double tmpbackInfo[19];
		GetBackInfo(tmpbackInfo,bbGetInputTransform()->GetMatrix(),bbGetInputOrigin() );

		if ( CompareBackInfo(backInfoA,tmpbackInfo)==false ) 
		{
			GetBackInfo(backInfoA,bbGetInputTransform()->GetMatrix(),bbGetInputOrigin() );

			//slicer =vtkImageReslice::New();
			slicer->SetInput( image->GetOutput() );
			slicer->SetInformationInput( image->GetOutput() );
			slicer->SetResliceTransform(bbGetInputTransform());
 			slicer->SetOutputOrigin( -(bbGetInputOrigin()[0]) , -(bbGetInputOrigin()[1]) , -(bbGetInputOrigin()[2]) );

			if(bbGetInputInterpolate())
			{
				slicer->InterpolateOn();
			}		
			slicer->Update();

			//imageResult = vtkImageChangeInformation::New();
			imageResult->SetInput( slicer->GetOutput() );
			double spc[3];
			bbGetInputIn()->GetSpacing(spc);
			imageResult->SetOutputSpacing( spc ); 
			imageResult->SetOutputOrigin( 0,0,0 ); 
	
			bbSetOutputOut( imageResult->GetOutput() );

			if (bbGetInputTransform()!=NULL)
			{ 
		  	 	bbGetInputTransform()->Update();
		   		vtkMatrix4x4 *m = bbGetInputTransform()->GetMatrix();
		   		if (m!=NULL)
		   		{
		     			printf("EED ReSlicerBox::Process Translation %d %d %d \n",-(bbGetInputOrigin()[0]),-(bbGetInputOrigin()[1]),-(bbGetInputOrigin()[2]));
		     			printf("EED ReSlicerBox::Process Matrix %f %f %f %f\n", m->GetElement(0,0),m->GetElement(0,1),m->GetElement(0,2),m->GetElement(0,3));
		     			printf("EED ReSlicerBox::Process Matrix %f %f %f %f\n", m->GetElement(1,0),m->GetElement(1,1),m->GetElement(1,2),m->GetElement(1,3));
		     			printf("EED ReSlicerBox::Process Matrix %f %f %f %f\n", m->GetElement(2,0),m->GetElement(2,1),m->GetElement(2,2),m->GetElement(2,3));
		     			printf("EED ReSlicerBox::Process Matrix %f %f %f %f\n", m->GetElement(3,0),m->GetElement(3,1),m->GetElement(3,2),m->GetElement(3,3));
	     	   		} // if m 
			} // if Transform
		} // Compare BackInfo
	} else {
			bbSetOutputOut( NULL );
	}  
}


void ReSlicerBox::bbUserSetDefaultValues()
{ 
	std::vector<int> empty;
	bbSetInputOrigin(empty); 
    	bbSetInputIn(NULL); 
    	bbSetInputTransform(NULL);
    	bbSetOutputOut(NULL);

	bbSetInputCentered(false);
	bbSetInputInterpolate(false);
  
	sizeBackInfo=19;
	for (int i=0; i<sizeBackInfo; i++)
	{
		backInfoA[i]=0;
	} // for
}


void ReSlicerBox::bbUserInitializeProcessing()
{
 
//  THE INITIALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should allocate the internal/output pointers  
//    if any  
	image = vtkImageChangeInformation::New();
    slicer =vtkImageReslice::New();
	imageResult = vtkImageChangeInformation::New();
}
	
void ReSlicerBox::bbUserFinalizeProcessing()
{ 
	image->Delete();
	slicer->Delete();
    imageResult->Delete();
}

}
// EO namespace bbPackRecalage
