/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#include "bbPackRecalageResampleBox.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage, ResampleBox)
BBTK_BLACK_BOX_IMPLEMENTATION(ResampleBox, bbtk::AtomicBlackBox);
void ResampleBox::Process()
{
    if(bbGetInputIn() != NULL && bbGetInputFactor() != 0)
	{
		double factor = bbGetInputFactor();
		resample->SetInput(bbGetInputIn());
		resample->SetAxisMagnificationFactor(0, factor);
		resample->SetAxisMagnificationFactor(1, factor);
		resample->SetAxisMagnificationFactor(2, factor);
		resample->Update();
		vtkImageData *image = resample->GetOutput();
		std::cout << "NTU: new spacing!" << image->GetExtent()[1] << " " << image->GetExtent()[3] << " " << image->GetExtent()[5] << " " << image->GetSpacing()[0] << " " << image->GetSpacing()[1] << " " << image->GetSpacing()[2] << std::endl;
		bbSetOutputOut(resample->GetOutput());
	}
	else
	{
		bbSetOutputOut(NULL);
	}
}

void ResampleBox::bbUserSetDefaultValues()
{
    bbSetInputIn(NULL);
	bbSetInputFactor(0);
	bbSetOutputOut(NULL);
}

void ResampleBox::bbUserInitializeProcessing()
{
	resample = vtkImageResample::New();
}

void ResampleBox::bbUserFinalizeProcessing()
{
	resample->Delete(); 
}

}
// EO namespace bbPackRecalage


