/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#include "bbPackRecalageSurfaceCreator.h"
#include "bbPackRecalagePackage.h"

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

#include "vtkActorCollection.h"

namespace bbPackRecalage
{



BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,SurfaceCreator)
BBTK_BLACK_BOX_IMPLEMENTATION(SurfaceCreator,bbtk::AtomicBlackBox);
void SurfaceCreator::Process()
{
    surface1 = new Surface(bbGetInputImage1(),bbGetInputHeight1(),bbGetInputColor1());
	surface2 = new Surface(bbGetInputImage2(),bbGetInputHeight2(),bbGetInputColor2());

	if(firsttime == true)
	{
        bbSetOutputOut1(surface1->getSurface());
		bbSetOutputOut2(surface2->getSurface());
	}   

	if (bbGetInputRenderer()!=NULL)
     {       
	   firsttime = false;

	   bbGetInputRenderer()->RemoveAllViewProps();	   

       bbGetInputRenderer()->AddActor( surface1->getSurface());
	   bbGetInputRenderer()->AddActor( surface2->getSurface());

	   bbGetInputRenderer()->Render();
     }  
}
void SurfaceCreator::bbUserSetDefaultValues()
{
 
//  SET HERE THE DEFAULT INPUT/OUTPUT VALUES OF YOUR BOX  
//    Here we initialize the input 'In' to 0 
    firsttime=true;
	bbSetInputImage1(NULL);
	bbSetInputHeight1(0);
	bbSetInputColor1("");
	bbSetInputImage2(NULL);
	bbSetInputHeight2(0);
	bbSetInputColor2("");
	bbSetInputRenderer(NULL);
  
}
void SurfaceCreator::bbUserInitializeProcessing()
{
 
//  THE INITIALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should allocate the internal/output pointers  
//    if any  
 
  
}
void SurfaceCreator::bbUserFinalizeProcessing()
{
 
//  THE FINALIZATION METHOD BODY : 
//    Here does nothing  
//    but this is where you should desallocate the internal/output pointers  
//    if any 

	delete surface1;
	delete surface2;
  
}
}
// EO namespace bbCreaRecalage


