/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------   
*/


#include "bbPackRecalageTransform2DBox.h"
#include "bbPackRecalagePackage.h"
namespace bbPackRecalage
{

BBTK_ADD_BLACK_BOX_TO_PACKAGE(PackRecalage,Transform2DBox)
BBTK_BLACK_BOX_IMPLEMENTATION(Transform2DBox,bbtk::AtomicBlackBox);
void Transform2DBox::Process()
{
	if(!bbGetInputCenterPoint().empty())
		{
			//	The inputs are set in the library transformer
			transformer->SetCenterPoint( bbGetInputCenterPoint() );
			transformer->SetAngle( bbGetInputAngle() );
			transformer->SetScaleX( bbGetInputScaleX() );
			transformer->SetScaleY( bbGetInputScaleY() );
			transformer->SetScaleZ( bbGetInputScaleZ() );

			// The calculation of the transformations are made
  			transformer->Run();
			// We get the results of transformer and set it as result of this box
			bbSetOutputOut( transformer->GetResult() );			
		}
		else
		{
			bbSetOutputOut( NULL );
		}
  
}
void Transform2DBox::bbUserSetDefaultValues()
{
		//We initialize the points with an empty vector, the angle in 0 and the scales in 1   
		std::vector<int> nuevo(3,0);
		nuevo.push_back(0);
		bbSetInputCenterPoint(nuevo); 
		bbSetInputAngle(0); 
		bbSetInputScaleX(100);
		bbSetInputScaleY(100);
		bbSetInputScaleZ(100);
		bbSetOutputOut(NULL);		
  
}
void Transform2DBox::bbUserInitializeProcessing()
{
		//We initialize the transformer
		transformer=new Transformer();
 
  
}
void Transform2DBox::bbUserFinalizeProcessing()
{
		//We delete the transformer
		delete transformer;
  
}
}
// EO namespace bbPackRecalage
