/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    

#include "vtkImageData.h"
#include "vtkImageResample.h"
#include <iostream>
#include <fstream>
#include <string>
#include <vector>

class CheckBoard
{
	public:	
		CheckBoard();
		~CheckBoard();

		//Initialize newImage points
		void initialize(int dimensions[], double spacing[]);

		//Calculate the new image and save it in the attribute image
		void calculateImage();
		
		//Gets the result
		vtkImageData* getFilteredImage();
		
		//Gets the image Size
		int getImageSize();

		//Constructs new image from image 2
		void createImage(vtkImageData *img1, vtkImageData *img2, int sizeX, int sizeY);

		void setInputImage1(vtkImageData *_image);

		void setInputImage2(vtkImageData *_image);

		void setCols(int cols);

		void setRows(int rows);
		template <class T> void createImageByType(T* dataImagePointer1, T* dataImagePointer2, T* dataImageResultPointer, vtkImageData *img1, vtkImageData *img2, int sizeX, int sizeY);

	// --- Atributes --- //
	private: 

		bool processed;

		int type;

		vtkImageData *image1;

		vtkImageData *image2;

		//Resulting image
		vtkImageData *newImage;

		//Image Resampler
		vtkImageResample *resample;

		//Rsulting image from the resampler
		vtkImageData *result;

		//Total number of divisions for the X axis (colums)
		int squaresX;

		//Total number of divisions for the Y axis (rows)
		int squaresY; 

		// Image 1 extent (iniX, finX, iniY, finY, iniZ, finZ)
		int extImg1[6];
		// Dimensionality image 1
		int dimImg1[3];
		// Image 1 spacing
		double spcImg1[3];

		// Image 2 extent (iniX, finX, iniY, finY, iniZ, finZ)
		int extImg2[6];
		// Dimensionality image 2
		int dimImg2[3];
		// Image 2 spacing
		double spcImg2[3];

};

//#endif


