/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    

#include "Convolution.h"

/*
* Constructor
*/
//------------------------------------------------------------
Convolution::Convolution()
{
	_image=NULL;
	_convolve = vtkImageConvolve::New();
	_cast = vtkImageCast::New();
}

/*
* Destructor
*/
//------------------------------------------------------------
Convolution::~Convolution()
{
	if (_convolve != NULL ) { _convolve->Delete(); }
	if (_cast != NULL ) { _cast->Delete(); }
}

vtkImageData *Convolution::getImage()
{
	return _cast->GetOutput();
}

void Convolution::setImage(vtkImageData *image)
{
	_image = image;
	_convolve->SetInput(_image);
}

void Convolution::setFactor(double factor)
{
	_factor = (factor/100.0)*5.0;	
}

void Convolution::setOn(bool on)
{
	_on = on;
}

void Convolution::Run()
{
	if(_on)
	{
		double kernel[] = {0.0,1.0,0.0,1.0,-_factor,1.0,0.0,1.0,0.0};
		_convolve->SetKernel3x3(kernel);
		_convolve->Update();
		_cast->SetInput(_convolve->GetOutput());
		//_cast->SetOutputScalarTypeToDouble();
		_cast->Update();
	}
	else
	{
		_cast->SetInput(_image);
		_cast->SetOutputScalarType(_image->GetScalarType());
		_cast->Update();
	}	
}
