/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    

//----------------------------------------------------------------------------
// Class definition include
//----------------------------------------------------------------------------

#include "MyGridOnImageGenerator.h"

//----------------------------------------------------------------------------
// Class implementation
//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
// Builder
//----------------------------------------------------------------------------

MyGridOnImageGenerator::MyGridOnImageGenerator( vtkImageData* nImage, double nScpX, double nScpY, double nScpZ)
{
	spcX = nScpX;
	spcY = nScpY;
	spcZ = nScpZ;
	image = nImage;
}

//----------------------------------------------------------------------------
// Destructor
//----------------------------------------------------------------------------

MyGridOnImageGenerator::~MyGridOnImageGenerator( )
{

}
//----------------------------------------------------------------------------
// Methods
//----------------------------------------------------------------------------


void MyGridOnImageGenerator::setScpX(double nScpX)
{
	spcX = nScpX;
}

void MyGridOnImageGenerator::setScpY(double nScpY)
{
	spcY = nScpY;
}

void MyGridOnImageGenerator::setScpZ(double nScpZ)
{
	spcZ = nScpZ;
}


void MyGridOnImageGenerator::setImage(vtkImageData* nImage)
{
	image = nImage;
}

vtkImageData* MyGridOnImageGenerator::getGridOnImage( )
{
	//Variables
	double spc[3];
	int dims[3];
	int sizeX = 0, sizeY = 0, sizeZ = 0;
	double minMaxValue[2];
	double minValue = 0, maxValue = 0;
	int spcVoxelX = 0, spcVoxelY = 0, spcVoxelZ = 0;

	vtkImageData* gridImage = vtkImageData::New();
	gridImage->ShallowCopy(image);
	gridImage->Update();

	//Get image spacing, size and mix and max values
	gridImage->GetSpacing(spc);
	gridImage->GetDimensions(dims);
	sizeX = dims[0];
	sizeY = dims[1];
	sizeZ = dims[2];
	gridImage->GetScalarRange(minMaxValue);
	minValue = minMaxValue[0];
	maxValue = minMaxValue[1];

	//Grid spacing in voxels
	spcVoxelX = spcX / spc[0];
	spcVoxelY = spcY / spc[1];
	spcVoxelZ = spcZ / spc[2];

	std::cout << "spcVoxelX:" << spcVoxelX << ", spcVoxelY:" << spcVoxelY << ", spcVoxelZ:" << spcVoxelZ <<std::endl;
	std::cout << "minValue:" << minValue << ", maxValue:" << maxValue << std::endl;
	std::cout << "sizeX:" << sizeX << ", sizeY:" << sizeY << ", sizeZ:" << sizeZ <<std::endl;

	for(int px = 0; px < sizeX; px++)
	{
		for(int py = 0; py < sizeY; py++)
		{
			for(int pz = 0; pz < sizeZ; pz++)
			{
				if(px % spcVoxelX == 0 || py % spcVoxelY == 0 || pz % spcVoxelZ == 0)
				{
					//std::cout << "In" ;
					unsigned char* pointer = (unsigned char*) gridImage->GetScalarPointer(px, py, pz);
					if( (*pointer - minValue) < (maxValue - *pointer) )
						*pointer = maxValue;
					else
						*pointer = minValue;
				}
			}
		}
	}


	return gridImage;
}

