/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    

#ifndef __MyGridOnImageGenerator_h__
#define __MyGridOnImageGenerator_h__

//-----------------
// C++
//-----------------


//-----------------
// VTK
//-----------------

#include "vtkImageData.h"

//------------------------------------------------------------------------------
// Creates a grid over an image. It is usually used to visualized the deformation
// field after a non-rigid registration. The contrast in the final image is based
// on the maximum and minimum values over the entire image.
//------------------------------------------------------------------------------
class MyGridOnImageGenerator
{
public:

	//------------------------------------------------------------
	//Builder
	//------------------------------------------------------------

	/*
	 * Class builder
	 * @param nImage is the input image
	 * @param nScpX is the spacing in X direction
	 * @param nScpY is the spacing in Y direction
	 * @param nScpZ is the spacing in Z direction
	 */
	MyGridOnImageGenerator(vtkImageData* nImage, double nScpX, double nScpY, double nScpZ);

	//------------------------------------------------------------
	//Destructor
	//------------------------------------------------------------

	~MyGridOnImageGenerator();

	//------------------------------------------------------------
	//Public methods
	//------------------------------------------------------------

	/*
	 * Method that changes the spacing in X
	 * param nScpX the new value for the spacing in X
	 */
	void setScpX(double nScpX);

	/*
	 * Method that changes the spacing in Y
	 * param nScpY the new value for the spacing in Y
	 */
	void setScpY(double nScpY);


	/*
	 * Method that changes the spacing in Z
	 * param nScpZ the new value for the spacing in Z
	 */
	void setScpZ(double nScpZ);

	/*
	 * Method that changes the input image
	 * @param nImage is the new image
	 */
	void setImage(vtkImageData* nImage);

	/**
	 * Method that generates the image with the grid
	 * @return The image with the grid
	 */
	vtkImageData* getGridOnImage( );

private:

	//------------------------------------------------------------
	//Private methods
	//------------------------------------------------------------


	//------------------------------------------------------------
	//Attributes
	//------------------------------------------------------------

	/*
	 * Spcing in X directioin
	 */
	double spcX;

	/*
	 * Spcing in Y directioin
	 */
	double spcY;

	/*
	 * Spcing in Z directioin
	 */
	double spcZ;

	/**
	 * Input image
	 */
	vtkImageData* image;
};

//------------------------------------------------------------------------------
#endif
