/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    

#include "PlaneReorientation.h"

/*
* Constructor
*/
//------------------------------------------------------------
PlaneReorientation::PlaneReorientation()
{
	_transform=vtkTransform::New();
}

/*
* Destructor
*/
//------------------------------------------------------------
PlaneReorientation::~PlaneReorientation()
{
	if (_transform != NULL ) { _transform->Delete(); }
}

void PlaneReorientation::CalculateNormal()
{
	normal[0]=(a[1]*b[2])-(a[2]*b[1]);
	normal[1]=(a[2]*b[0])-(a[0]*b[2]);
	normal[2]=(a[0]*b[1])-(a[1]*b[0]);

	vtkMath::Normalize(normal);

	std::cout << "Normal axis : " << "X: " << normal[0] << " Y: " << normal[1] << " Z: " << normal[2] << std::endl;
}

void PlaneReorientation::SetVectors(std::vector<int> pointsX, std::vector<int> pointsY, std::vector<int> pointsZ, std::vector<std::string> labels)
{
	//This part is for head reorientation using the chiasma and optical nerves
	if(labels[0].compare("CHIASMA") == 0 || labels[1].compare("CHIASMA") == 0 || labels[2].compare("CHIASMA") == 0)
	{
		int i;
		for(i = 0; i < 2; i++)
		{
			//Gets the point that represents the optic chiasma and sets it as the origin point
			if(labels[i].compare("CHIASMA")==0)
			{
				o[0] = pointsX[i];
				o[1] = pointsY[i];
				o[2] = pointsZ[i];
			}
			//The point that represents the right eye (and subsequent first vector)
			else if(labels[i].compare("RY")==0)
			{
				a[0] = pointsX[i];
				a[1] = pointsY[i];
				a[2] = pointsZ[i];
			}
			//The point that represents the left eye (and subsequent second vector)
			else if(labels[i].compare("LY")==0)
			{
				b[0] = pointsX[i];
				b[1] = pointsY[i];
				b[2] = pointsZ[i];
			}
		}

		//Creates the first vector
		a[0] = a[0] - o[0];
		a[1] = a[1] - o[1];
		a[2] = a[2] - o[2];

		//Creates the second vector
		b[0] = b[0] - o[0];
		b[1] = b[1] - o[1];
		b[2] = b[2] - o[2];
	}
	else
	{
		/*First Vector*/
		a[0] = pointsX[1]-pointsX[0];
		a[1] = pointsY[1]-pointsY[0];
		a[2] = pointsZ[1]-pointsZ[0];

		/*Second Vector*/
		b[0] = pointsX[2]-pointsX[0];
		b[1] = pointsY[2]-pointsY[0];
		b[2] = pointsZ[2]-pointsZ[0];
	}
}

vtkTransform* PlaneReorientation::getTransform()
{
	return _transform;
}

void PlaneReorientation::Run()
{

}
