/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    

#include "Substraction.h"

Substraction::Substraction(vtkImageData* imageData1,vtkImageData* imageData2, int uZLevel,int lZLevel, std::vector<double> uColor, std::vector<double> lColor, std::vector<double> mColor)
{
	imageResult= vtkImageData::New();
	sizeImage=0;
	uZeroLevel=uZLevel;
	lZeroLevel=lZLevel;
	if(uColor.size() != 0)
	{
		upperColor[0] = uColor[0];
		upperColor[1] = uColor[1];
		upperColor[2] = uColor[2];
	}
	else
	{
		upperColor[0] = 255;
		upperColor[1] = 255;
		upperColor[2] = 255;
	}	
	if(mColor.size() != 0)
	{
		mediumColor[0] = mColor[0];
		mediumColor[1] = mColor[1];
		mediumColor[2] = mColor[2];
	}
	else
	{
		mediumColor[0] = 125;
		mediumColor[1] = 125;
		mediumColor[2] = 125;
	}	
	if(lColor.size() != 0)
	{
		lowerColor[0] = lColor[0];
		lowerColor[1] = lColor[1];
		lowerColor[2] = lColor[2];
	}
	else
	{
		lowerColor[0] = 0;
		lowerColor[1] = 0;
		lowerColor[2] = 0;
	}
	
	//Original image type this case is an unsigned char (3)
	//int t=imageData1->GetScalarType(); // JPR : unused
	//substracting the image
	substractImage(imageData1, imageData2);
}

Substraction::~Substraction()
{
	if(imageResult!=NULL)imageResult->Delete();
}

//----------------------------------------------------------------------------
// Methods
//----------------------------------------------------------------------------

/*
Calculate the new image and save it in the attribute imageResult
it is used if the user had given the imageData
*/
void Substraction::substractImage(vtkImageData* imageData1, vtkImageData* imageData2)
{
	//dimensions of the image (extent)
    int ext[6];
	//setting the dimensionality (1d or 2d or 3d )
    int newDim[3];
	//image spacing
    double spc[3];
  
	//getting the information from the original image
    imageData1->GetSpacing(spc);
    imageData1->GetExtent(ext);
	
	//this a 2d image
    newDim[0]=ext[1]-ext[0]+1;
    newDim[1]=ext[3]-ext[2]+1;
    newDim[2]=1;// in general it is ext[5]-ext[4]+1


    imageType = imageData1->GetScalarType();
	//initializing the image that represents the substracted image
    initialize(newDim,spc);
	//Time to substract
    substract(imageData1, imageData2);	
}

/*
  getting ready the imageResult
*/
void Substraction::initialize(int dimensions[], double spacing[])
{
	//setting image data of the imageResult
	imageResult->SetScalarType(imageType);
	imageResult->SetSpacing(spacing);
	imageResult->SetDimensions(dimensions);
	imageResult->AllocateScalars();
	imageResult->Update();
}

/*
	 Setting the values for the
*/
void Substraction::substract(vtkImageData* imageData1, vtkImageData* imageData2)
{
	if(imageType == VTK_CHAR)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		char* dataImagePointer1=NULL;
		char* dataImagePointer2=NULL;
		char* dataImageResultPointer=NULL;
		
		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
	else if(imageType == VTK_UNSIGNED_CHAR)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		unsigned char* dataImagePointer1=NULL;
		unsigned char* dataImagePointer2=NULL;
		unsigned char* dataImageResultPointer=NULL;
		
		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
	else if(imageType == VTK_SIGNED_CHAR)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		signed char* dataImagePointer1=NULL;
		signed char* dataImagePointer2=NULL;
		signed char* dataImageResultPointer=NULL;
		
		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
	else if(imageType == VTK_SHORT)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		short* dataImagePointer1=NULL;
		short* dataImagePointer2=NULL;
		short* dataImageResultPointer=NULL;

		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);		
	}
	else if(imageType == VTK_UNSIGNED_SHORT)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		unsigned short* dataImagePointer1=NULL;
		unsigned short* dataImagePointer2=NULL;
		unsigned short* dataImageResultPointer=NULL;
		
		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
	else if(imageType == VTK_INT)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		int* dataImagePointer1=NULL;
		int* dataImagePointer2=NULL;
		int* dataImageResultPointer=NULL;
		
		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
	else if(imageType == VTK_UNSIGNED_INT)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		unsigned int* dataImagePointer1=NULL;
		unsigned int* dataImagePointer2=NULL;
		unsigned int* dataImageResultPointer=NULL;
		
		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
	else if(imageType == VTK_LONG)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		long* dataImagePointer1=NULL;
		long* dataImagePointer2=NULL;
		long* dataImageResultPointer=NULL;

		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
	else if(imageType == VTK_UNSIGNED_LONG)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		unsigned long* dataImagePointer1=NULL;
		unsigned long* dataImagePointer2=NULL;
		unsigned long* dataImageResultPointer=NULL;
		
		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
	else if(imageType == VTK_FLOAT)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		float* dataImagePointer1=NULL;
		float* dataImagePointer2=NULL;
		float* dataImageResultPointer=NULL;
		
		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
	else if(imageType == VTK_DOUBLE)
	{
		/*
		images pointers
		*/
		// pointers to get into the image
		double* dataImagePointer1=NULL;
		double* dataImagePointer2=NULL;
		double* dataImageResultPointer=NULL;
		
		substractByType(dataImagePointer1, dataImagePointer2, dataImageResultPointer, imageData1, imageData2);
	}
}

template <class T> 
void Substraction::substractByType(T* dataImagePointer1, T* dataImagePointer2, T* dataImageResultPointer, vtkImageData *imageData1, vtkImageData *imageData2)
{
	// we start where the  image starts
	dataImagePointer1=(T*)imageData1->GetScalarPointer(0,0,0);
	dataImagePointer2=(T*)imageData2->GetScalarPointer(0,0,0);
	dataImageResultPointer=(T*)imageResult->GetScalarPointer(0,0,0);
	/*
	Image Size
	*/
	int ext[6];
	imageData1->GetExtent(ext);
	int sx,sy,sz;
	sx=ext[1]-ext[0]+1;
	sy=ext[3]-ext[2]+1;
	sz=ext[5]-ext[4]+1;

	sizeImage=sx*sy*sz;
	//-----------------
	//A3	
	//-----------------
	//walking in the image
	int i=0,j=0,k=0,counter=0,nU=0,nL=0,nZ=0;
	double sum1=0,sum2=0;
	for(i=0;i<sx;i++)
	{
		for(j=0;j<sy;j++)
		{
			for(k=0;k<sz;k++)
			{
					
				// this is for getting just the grey level in that position
				//originalValue=(short)imageData->GetScalarComponentAsFloat(i,j,k,0);
		
				// we get the pointer to the position (i,j,k)y that way we can get the 
				//grey level and we can change it

				dataImagePointer1=(T*)imageData1->GetScalarPointer(i,j,k);
				dataImagePointer2=(T*)imageData2->GetScalarPointer(i,j,k);
				dataImageResultPointer=(T*)imageResult->GetScalarPointer(i,j,k);

				sum1=(int)(dataImagePointer1[0]) + (int)(dataImagePointer1[1]) + (int)(dataImagePointer1[2]);
				sum1=sum1/3;
				sum2=(int)(dataImagePointer2[0]) + (int)(dataImagePointer2[1]) + (int)(dataImagePointer2[2]);
				sum2=sum2/3;				
				if((sum1 - sum2) < lZeroLevel)
				{
					dataImageResultPointer[0] =(T) lowerColor[0];
					dataImageResultPointer[1] =(T) lowerColor[1];
					dataImageResultPointer[2] =(T) lowerColor[2];
					nL++;
				}
				else if((sum1 - sum2) > uZeroLevel)
				{
					dataImageResultPointer[0] =(T) upperColor[0];
					dataImageResultPointer[1] =(T) upperColor[1];
					dataImageResultPointer[2] =(T) upperColor[2];
					nU++;
				}
				else
				{
					dataImageResultPointer[0] =(T) mediumColor[0];
					dataImageResultPointer[1] =(T) mediumColor[1];
					dataImageResultPointer[2] =(T) mediumColor[2];
					nZ++;
				}				
				counter++;
			}
		}
	}
}

/*
Returns the filtered image
*/
vtkImageData* Substraction::getSubstractedImage()
{
	return imageResult;
}

/*
	Get Image Size
*/
int Substraction::getImageSize()
{ 
	return sizeImage;
}
