/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    

#include "vtkImageData.h"

#include <string>
#include <vector>

class Substraction 
{

	//----------------------------------------------------------------------------------------
	// Methods definition
	//----------------------------------------------------------------------------------------
	public:
	//--------------------------
	//Constructor & Destructor
	//--------------------------		
		Substraction(vtkImageData* imageData1, vtkImageData* imageData2, int uZLevel,int lZLevel, std::vector<double> uColor, std::vector<double> lColor, std::vector<double> mColor);
		~Substraction();
	//--------------------------
	//Methods
	//--------------------------
		/*
		getting ready the points
		*/
		void initialize(int dimensions[],double spacing[]);
		/*
		Calculate the new image and save it in the attribute imageResult
		it is used if the user had given the imageData
		*/
		void substractImage(vtkImageData* imageData1, vtkImageData* imageData2);
		
		/*
		Returns the ImageResult
		*/
		vtkImageData* getSubstractedImage();
		
		/*
		 Get Image Size
		*/
		int getImageSize();
		
		/*
		constructing image substract
		*/
		void substract(vtkImageData* imageData1, vtkImageData* imageData2);

		/*
		Template method of substract for different image types
		*/
		template <class T> void substractByType(T* dataImagePointer1, T* dataImagePointer2, T* dataImageResultPointer, vtkImageData *imageData1, vtkImageData *imageData2);
		


	//----------------------------------------------------------------------------------------
	// Attributes declaration
	//----------------------------------------------------------------------------------------
	private: 
		/*
		 Substracted Image
		*/
		vtkImageData* imageResult;
		/*
		 image size dimx*dimy*dimz
		*/
		int sizeImage;
		/*
		upper zero level for doing the Substraction
		*/
		int uZeroLevel;
		/*
		lower zero level for doing the Substraction
		*/
		int lZeroLevel;
		/*
		Color for the upper threshold
		*/
		int upperColor[3];
		/*
		Color for the lower threshold
		*/
		int lowerColor[3];
		/*
		Color for the medium threshold
		*/
		int mediumColor[3];
		/*
		Image type
		*/
		int imageType;
};

