/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    

#include "vtkImageData.h"
#include "vtkProp3D.h"
#include "vtkRenderer.h"
#include "vtkPoints.h"
#include "vtkCellArray.h"

#include <string>

class Surface 
{
	//----------------------------------------------------------------------------------------
	// Methods definition
	//----------------------------------------------------------------------------------------
	public:
	//--------------------------
	//Constructor & Destructor
	//--------------------------		
		Surface(vtkImageData* imageData, int ZHeight, std::string iColor);
		~Surface();
	//--------------------------
	//Methods
	//--------------------------
		/*
		getting ready the points
		*/
		void initialize(int dimensions[],double spacing[]);
		/*
		Calculate the new image and save it in the attribute imageResult
		it is used if the user had given the imageData
		*/
		void createSurface(vtkImageData* imageData);
		
		/*
		Returns the Surface
		*/
		vtkActor* getSurface();
		
		/*
		constructing image surface
		*/
		void surface(vtkImageData* imageData);

		/*
		Template for constructing the surface by image type
		*/
		template <class T> void surfaceByType(T* dataImagePointer, vtkImageData* imageData, T max);
		


	//----------------------------------------------------------------------------------------
	// Attributes declaration
	//----------------------------------------------------------------------------------------
	private: 
		/*
		 Surface
		*/
		vtkActor* surfaceResult;
		
		/*
		Maximun height of the surface
		*/
		int height;
		
		/*
		Color for the surface
		*/
		std::string color;

		/*
		The type of image being viewed
		*/
		int imageType;

		/*
		The points of the surface
		*/
		vtkPoints* surfacePoints;

		/*
		Cells to be constructed from the surface
		*/
		vtkCellArray* surfaceCells;
};

