/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    


#ifndef Transformer3D_h
#define Transformer3D_h

#include "vtkTransform.h"
#include <vector>

class Transformer3D{
public: 
	Transformer3D();
    ~Transformer3D();
	void SetTransform(vtkTransform *transform);
	void SetRotationAxis(double* axis);
	void SetFirstTranslation(double* first);
	void SetSecondTranslation(double* second);
	void SetSecondRotationAxis(double* axis);
	void SetAngle(double angle);
	void SetSecondAngle(double angle);
	void Run();
	
    vtkTransform *GetResult();
	vtkTransform *GetFirstResult();
private:
	double _rotationAxis[3];
	double _secondRotationAxis[3];
	double _firstPoint[3];
	double _secondPoint[3];
	double _angle;
	double _secondAngle;
	
	vtkTransform *_transform;
};

#endif
