/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    


#include "Transformer3D1Point.h"
/*
	CONSTRUCTOR: Initializes the two points with empty vectors, the angle in 0.
*/
Transformer3D1Point::Transformer3D1Point() 
{
	std::vector<int> empty (3,0); 
	_centerPoint=empty;	
	//If the transform already exists, we delete it before we create a new transform 
	//and set the matrix with the identity matrix
	_transform= vtkTransform::New();
	_matrix = vtkMatrix4x4::New();
	_matrix->Identity();
	_transform->SetMatrix(_matrix);	
}

/*
	DESTRUCTOR
*/
Transformer3D1Point::~Transformer3D1Point()
{
	//We delete the existing transform
	if (_transform != NULL ) { _transform->Delete(); }
	if (_matrix != NULL ) { _matrix->Delete(); }
}

/*
	SETS A NEW TRANSFORM
*/
void Transformer3D1Point::SetTransform(vtkTransform *transform)
{
	_transform=transform;
}

/*
	SETS CENTER POINT
*/
void Transformer3D1Point::SetCenterPoint(std::vector<int> point)
{
    _centerPoint=point;
}

/*
	SETS THE ANGLE IN X
*/
void Transformer3D1Point::SetAngleX(double angle)
{
	_angleX=angle;
}

/*
	SETS THE ANGLE IN Y
*/
void Transformer3D1Point::SetAngleY(double angle)
{
	_angleY=angle;
}

/*
	SETS THE ANGLE IN Z
*/
void Transformer3D1Point::SetAngleZ(double angle)
{
	_angleZ=angle;
}

/*
	SETS THE X SCALE
*/
void Transformer3D1Point::SetScaleX(double scaleX)
{
	_scaleX=scaleX/100.0;
}

/*
	SETS THE Y SCALE
*/
void Transformer3D1Point::SetScaleY(double scaleY)
{
	_scaleY=scaleY/100.0;
}

/*
 SETS THE Y SCALE
 */
void Transformer3D1Point::SetScaleZ(double scaleZ)
{
	_scaleZ=scaleZ/100.0;
}

/*
	GETS THE RESULTANT TRANSFORM
*/
vtkTransform *Transformer3D1Point::GetResult()
{
	return _transform;
}

/*
	MAKES THE TRANSFORMATIONS
*/
void Transformer3D1Point::Run()
{	
	//Clears any old transformations in the pipeline
	_transform->Identity();

	//Make all transformations in post multiply mode
	_transform->PostMultiply();

	//Centers the image before applying the transformation
	_transform->Translate(-_centerPoint[0], -_centerPoint[1], -_centerPoint[2]);

	
	_transform->RotateWXYZ(_angleY, 0, 1, 0);
	_transform->RotateWXYZ(_angleX, 1, 0, 0);
	_transform->RotateWXYZ(_angleZ, 0, 0, 1);
	_transform->Scale(_scaleX, _scaleY,_scaleZ);

	//Returns the inverse of the transformation (NTU: Have no idea why we have to do this for the image to appear properly)
	_transform->Inverse();	
	_transform->Update();
}
