/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    


#ifndef Transformer3DV1_h
#define Transformer3DV1_h

#include "vtkTransform.h"
#include "vtkMatrix4x4.h"
#include <vector>

class Transformer3D1Point{
public: 
	Transformer3D1Point();
    ~Transformer3D1Point();
	void SetTransform(vtkTransform *transform);
	void SetCenterPoint(std::vector<int> point);
	void SetAngleX(double angle);
	void SetAngleY(double angle);
	void SetAngleZ(double angle);
	void SetScaleX(double scaleX);
	void SetScaleY(double scaleY);
	void SetScaleZ(double scaleZ);
	void Run();
	
    vtkTransform *GetResult();
private:
	std::vector<int> _centerPoint;
	double _angleX;
	double _angleY;
	double _angleZ;
	double _scaleX;
	double _scaleY;
	double _scaleZ;
	
	vtkTransform *_transform;
	vtkMatrix4x4 *_matrix;
};

#endif
