/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image 
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and 
#  abiding by the rules of distribution of free software. You can  use, 
#  modify and/ or redistribute the software under the terms of the CeCILL-B 
#  license as circulated by CEA, CNRS and INRIA at the following URL 
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html 
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability. 
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------      */                                                                    

#include "vtkImageData.h"
#include "vtkImageResample.h"
#include <iostream>
#include <fstream>
#include <string>
#include <vector>

class Transparency
{
	public:	
		Transparency();
		~Transparency();

		//Calculate the new image and save it in the attribute image
		void calculateImage();
		
		//Gets the result
		vtkImageData* getImage();
		
		void setImage1(vtkImageData *image);

		void setImage2(vtkImageData *image);

		void setPercent(int percent);

		//Initialize newImage points
		void initialize(int dimensions[], double spacing[]);

		//Constructs a new transparent image
		void createImage(vtkImageData *img1, vtkImageData *img2, int sizeX, int sizeY);

		//Template for constructing the image by image type
		template <class T> void createImageByType(T* dataImagePointer1, T* dataImagePointer2, T* dataImageResultPointer, vtkImageData *img1, vtkImageData *img2, int sizeX, int sizeY);

	// --- Atributes --- //
	private: 

		bool _processed;

		int _type;

		vtkImageData *_image1;

		vtkImageData *_image2;

		//Resulting image
		vtkImageData *_newImage;

		//Percent of transparency for the second image
		double _percent;

		// Image 1 extent (iniX, finX, iniY, finY, iniZ, finZ)
		int extImg1[6];
		// Dimensionality image 1
		int dimImg1[3];
		// Image 1 spacing
		double spcImg1[3];

		// Image 2 extent (iniX, finX, iniY, finY, iniZ, finZ)
		int extImg2[6];
		// Dimensionality image 2
		int dimImg2[3];
		// Image 2 spacing
		double spcImg2[3];

};

