/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifdef _USE_WXWIDGETS_



//==========================================================================
// WITH WX
//==========================================================================
#include "bbtkInterpreter.h"
#include "bbtkWxGUIHtmlBrowser.h" 
#include "bbtkWxGUIPackageBrowser2.h" 

//#include "../../src/icons/cc_run.xpm"
#include "../../src/icons/cc_exit.xpm"

using namespace bbtk;

class /*BBTK_EXPORT*/ WxGUIHelp : public wxFrame
//                                            public InterpreterUser
{
public:
  WxGUIHelp( wxWindow *parent, wxString title, wxSize size );
  ~WxGUIHelp();
  void OnButtonRun(wxCommandEvent& WXUNUSED(event));
  void OnButtonQuit(wxCommandEvent& WXUNUSED(event));

  //  WxGUIHtmlBrowser* mWxGUIHtmlBrowser;
  WxGUIPackageBrowser2* mWxGUIPackageBrowser;
  //  wxButton* mwxButtonRun;
  wxButton* mwxButtonQuit;

//  bool InterpreterUserHasOwnHtmlPageViewer() { return false; }
//  void InterpreterUserViewHtmlPage(const std::string&) {} 

  DECLARE_EVENT_TABLE(); 
};

enum
  {
    ID_Button_Run,
    ID_Button_Quit
  };

WxGUIHelp::WxGUIHelp( wxWindow *parent, wxString title, wxSize size )
  : wxFrame((wxFrame *)parent, -1, title, wxDefaultPosition, size)
//                                         InterpreterUser()  
{ 
  wxBoxSizer *helpsizer = new wxBoxSizer(wxVERTICAL);
  // mWxGUIHtmlBrowser = new WxGUIHtmlBrowser(this,wxSize(200,0));
  //  helpsizer->Add (mWxGUIHtmlBrowser,1, wxGROW|wxLEFT|wxRIGHT|wxTOP, 5  );
  mWxGUIPackageBrowser = new WxGUIPackageBrowser2(this);
  helpsizer->Add (mWxGUIPackageBrowser,1, wxGROW|wxLEFT|wxRIGHT|wxTOP, 5  );

  wxBoxSizer *btnsizer = new wxBoxSizer(wxHORIZONTAL);
  /*
  wxBitmap bmp_run(cc_run_xpm);
  mwxButtonRun = new wxBitmapButton(this,ID_Button_Run,bmp_run);
  btnsizer->Add( mwxButtonRun, 0, wxALL, 5  );
  */
  wxBitmap bmp_quit(cc_exit_xpm);
  mwxButtonQuit = new wxBitmapButton(this,ID_Button_Quit,bmp_quit);
  btnsizer->Add( mwxButtonQuit, 0, wxALL, 5  );

  helpsizer->Add( btnsizer );

  // Creates and sets the parent window of all bbtk windows
  /*
  wxWindow* top = new wxPanel(this,-1);//,_T("top"));
  top->Hide();
  Wx::SetTopWindow(top);
  */

  SetSizer(helpsizer);
  SetAutoLayout(true);
  Layout();

  // mWxGUIHtmlBrowser->GoHome();
  mWxGUIPackageBrowser->IncludeAll();
}

WxGUIHelp::~WxGUIHelp() {}

/*
void WxGUIHelp::OnButtonRun(wxCommandEvent& WXUNUSED(event))
{  
  //std::string filename = wx2std(mWxGUIHtmlBrowser->GetCurrentPage());
  std::string filename = mWxGUIHtmlBrowser->GetCurrentPage();
  size_t s = filename.length();
  
  Interpreter::Pointer I = Interpreter::New();
  I->SetThrow(true);

  if ((s>3) && (filename[s-1]=='s')
      && (filename[s-2]=='b')
      && (filename[s-3]=='b')
      && (filename[s-4]=='.'))
    {
      try 
	{
	  I->InterpretFile(filename);
	}
      catch (QuitException e) 
	{
	  std::cout << "QuitException caught"<<std::endl;
	}
      catch (Exception e)
	{
	  wxString mess;
	  mess += std2wx ( e.GetMessage() );
	  wxMessageBox(mess,_T("Error"),wxOK | wxICON_ERROR);
	}
      catch (...)
	{	  
	  wxMessageBox(_T("Undefined error during script execution"),
		       _T("Error"),wxOK | wxICON_ERROR);

	}
    }
  else
    {
      wxMessageBox(_T("You can only execute .bbs script files (click on [source] in the field 'To use it' of a box) !"),_T("Warning"),wxOK | wxICON_ERROR);
    }
  
  //delete I;
}
*/

void WxGUIHelp::OnButtonQuit(wxCommandEvent& WXUNUSED(event))
{
  Close();
}

//================================================================  
BEGIN_EVENT_TABLE(WxGUIHelp, wxFrame)
//  EVT_BUTTON(ID_Button_Run, WxGUIHelp::OnButtonRun )
  EVT_BUTTON(ID_Button_Quit, WxGUIHelp::OnButtonQuit )
END_EVENT_TABLE()
//================================================================



class myApp : public wxApp
{
public:
  bool OnInit( );
  int  OnExit() { return true; }
};

IMPLEMENT_APP(myApp);


bool myApp::OnInit( )
{	 
  wxApp::OnInit();
#ifdef __WXGTK__
  //See http://www.wxwindows.org/faqgtk.htm#locale
  setlocale(LC_NUMERIC, "C");
#endif
   wxInitAllImageHandlers();
   
   //  WxGUIHelp *I = new WxGUIHelp(0,_T("BBTK help browser"),wxSize(800,600));
   
   WxGUIPackageBrowser2Window*  I = 
     new WxGUIPackageBrowser2Window(0,_T("bbtk help"),wxSize(1000,800));
  SetTopWindow(I);  
  I->Show(true);
  return true;
}

/*
#if defined(_WIN32) 

//  How to have a Console and wxWidgets
//  http://www.wxwidgets.org/wiki/index.php/MSVC_Setup_Guide
//   In Visual C++ 6 (7 should be similar), to create an application that is both a console application 
//  (cout's to the console are visible) and has a wxWidgets GUI, 
//  you need to use the linker option "/subsystem:console" and the following code:
int main(int argc, char* argv[])
{
	return WinMain(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), SW_SHOWNORMAL);
}
#endif // defined(_WIN32) 
*/
	
#else
//==========================================================================
// WITHOUT WX
//==========================================================================
int main(int argc, char* argv[])
{  
  return 0;
}
	 
// EOF
#endif //#ifdef _USE_WXWIDGETS_



