/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#include <bbtkConfigurationFile.h>
#include <bbtkUtilities.h>
#include <stdlib.h>
using namespace bbtk;


//==========================================================================
int main(int argc, char **argv)
{
  if (argc!=2)
    {
      std::cout << "usage : bbPlugPackage <path_to_package>" << std::endl;
      return (int)1;
    }

  std::string path(argv[1]);
  #ifdef WIN32
  std::string fname = path + "\\bbtkPackage"; 
  #else
  std::string fname = path + "/bbtkPackage"; 
  #endif
  

  if ( ! Utilities::FileExists( fname ) )
    {
      std::cout << "* ERROR : The directory '"<<path<<"' does not contain a 'bbtkPackage' file"	<< std::endl;
      return (int)2; 
    }
	
  std::ifstream f;
  f.open(fname.c_str());
  std::string pname;
  f >> pname;
  while(pname[0] == '#')
  {
    getline(f, pname, '\n');
    f >> pname;
  }
    
  f.close();
  
  
  ConfigurationFile::GetInstance().AddPackagePathsAndWrite( path );
  
  std::string command;
#if defined(WIN32)
	command = "\"";
#endif
  command += ConfigurationFile::GetInstance().Get_bin_path();
  command += ConfigurationFile::GetInstance().Get_file_separator();
  command += "bbRegeneratePackageDoc";
#if defined(WIN32)
  command += "\"";
#endif
  command += " " + pname + " -q";
  std::cout << "executing '" << command << "'" << std::endl;
if ( system ( command.c_str() ) )
 {
    std::cout << "An error occured while running '" 
		<< command << "'" << std::endl;
     // return 1; Feature #1676 - DFGO
  }

	 

  command = "";
#if defined(WIN32)
  command = "\"";
#endif
  command += ConfigurationFile::GetInstance().Get_bin_path();
  command += ConfigurationFile::GetInstance().Get_file_separator();
  command += "bbRegenerateBoxesLists";
#if defined(WIN32)
  command += "\"";
#endif
  command += " -q";
 std::cout << "executing '" << command << "'" << std::endl;
  if ( ! system ( command.c_str() ) )
    {
      std::cout << "Package '" 
		<< pname << "' successfully plugged in" << std::endl;
    }
  else 
    {
      std::cout << "An error occured while running '" 
		<< command << "'" << std::endl;
      //return 1; Feature #1676 - DFGO
    }
  return (int)0;
}
//==========================================================================


