/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#include <bbtkInterpreter.h>
#include <bbtkConfigurationFile.h>

//==========================================================================
int main(int argc, char **argv)
{
  if (argc>1)
    {
      if (argv[1][1]=='q') 
	bbtk::MessageManager::SetMessageLevel("max",0);
      else if (argv[1][1]=='v')
	bbtk::MessageManager::SetMessageLevel("all",9);		 
      else 
	{
	  std::cout << "usage : bbRegenerateBoxesLists [-q|-v] (quiet or verbose)" << std::endl;
	  return 0;
	}
    }

  try
    {
      bbtk::Interpreter::Pointer I = bbtk::Interpreter::New();
      I->SetCommandLine(true);
      I->SetThrow(false);

      std::string doc_path = bbtk::ConfigurationFile::GetInstance().Get_doc_path();
      doc_path += bbtk::ConfigurationFile::GetInstance().Get_file_separator();
      doc_path += "bbdoc";
      doc_path += bbtk::ConfigurationFile::GetInstance().Get_file_separator();

      I->InterpretLine( "exec freeze_no_error");
      I->InterpretLine( "include *");
      I->GetExecuter()->GetFactory()->CreateHtmlIndex(bbtk::Factory::Initials, doc_path   + "index-alpha.html");
      I->GetExecuter()->GetFactory()->CreateHtmlIndex(bbtk::Factory::Packages, doc_path   + "index-package.html");
      I->GetExecuter()->GetFactory()->CreateHtmlIndex(bbtk::Factory::Categories, doc_path + "index-category.html");
      I->GetExecuter()->GetFactory()->CreateHtmlIndex(bbtk::Factory::Adaptors, doc_path   + "index-adaptors.html");

    }
  catch (bbtk::Exception e)
    {
      std::cout << "* ERROR : "<<e.GetErrorMessage()<<std::endl;
      return 1;
    }

  // JGRR & CM : this kills this never-ending process, when it's supposed to.
  std::cout << "bbRegenerateBoxesLists has finished normally. It will be aborted on purpose."<< std::endl; 
  abort();
  // EO JGRR & CM
  return 0;
}
//==========================================================================


