/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#include <bbtkWx.h>
#include <bbtkInterpreter.h>
#include <bbtkConfigurationFile.h>
#include <bbtkUtilities.h>

//==========================================================================
void RegenerateDoc ( bbtk::Package::Pointer p, std::string& doc_path )
{
	
  std::string pack_name(p->GetName());
  std::string pack_path = doc_path + pack_name;
  // Creating directory
  if ( ! bbtk::Utilities::FileExists(pack_path) )
    {
      std::string command("mkdir \"" +pack_path+ "\"");
      system( command.c_str() );
    }
  std::string pack_index(pack_path);
  pack_index += bbtk::ConfigurationFile::GetInstance().Get_file_separator();
  pack_index += "index.html";
  
  std::cout << "* Generating doc for package '"<<pack_name<<"' in "
	    << pack_index << std::endl;
  
  p->SetDocURL(pack_index);
  p->SetDocRelativeURL("index.html");
	
	
  p->CreateHtmlPage(pack_index,"bbtk",pack_name,"","",0,0,true); //true);
	
	
}


void Usage()
{
  std::cout << "usage : bbRegeneratePackageDoc [<package name>|-a] [-q|-v]" 
	    << std::endl
	    << "        -a : All packages"<<std::endl
	    << "        -q : Quiet"<<std::endl
	    << "        -v : Verbose"<<std::endl;
}

//==========================================================================
int main(int argc, char **argv)
{
  std::string pack("-a");
  if (argc==2) 
    {
      pack = std::string(argv[1]);
    }
  else if (argc==3)
    {
      pack = std::string(argv[1]);
      std::string param(argv[2]);
      if (param=="-q") bbtk::MessageManager::SetMessageLevel("max",0);
      else if (param=="-v") bbtk::MessageManager::SetMessageLevel("all",9);
      else 
	{
	  Usage();
	  return 0;
	}
    }
  else 
    {
      Usage();
      return 0;
    }
 
  try
    {
		std::string doc_path = bbtk::ConfigurationFile::GetInstance().Get_doc_path();
      doc_path += bbtk::ConfigurationFile::GetInstance().Get_file_separator();
      doc_path += "bbdoc";
      doc_path += bbtk::ConfigurationFile::GetInstance().Get_file_separator();
      bbtk::Interpreter::Pointer I = bbtk::Interpreter::New();
      I->SetCommandLine(true);
      I->SetThrow(false);
//std::cout<<"JCP bbRegeneratePackageDoc.cpp  I->InterpretLine( exec freeze_no_error);"<<std::endl;
	  I->InterpretLine( "exec freeze_no_error");
      if (pack != "-a") 
	{

		I->InterpretLine( "include "+pack);
		I->InterpretLine( "include "+pack+"-appli");
		bbtk::Package::Pointer p = I->GetExecuter()->GetFactory()->GetPackage(pack);
//std::cout<<"JCP bbRegeneratePackageDoc.cpp RegenerateDoc(I->GetExecuter()->GetFactory()->GetPackage(pack),doc_path);"<<std::endl;
		RegenerateDoc(I->GetExecuter()->GetFactory()->GetPackage(pack),doc_path);
	}
      else
	{
//std::cout<<"JCP bbRegeneratePackageDoc.cpp I->InterpretLine( include );"<<std::endl;
		I->InterpretLine( "include *");
		bbtk::Factory::PackageMapType::const_iterator i;
	  for (i  = I->GetExecuter()->GetFactory()->GetPackageMap().begin();
	       i != I->GetExecuter()->GetFactory()->GetPackageMap().end();
	       ++i)
	    {
//std::cout<<" if (i->second->GetName()==user) continue;"<<std::endl;
	      if (i->second->GetName()=="user") continue;
	      RegenerateDoc(i->second,doc_path);
	    }
	}
    }
  catch (bbtk::Exception e)
    {
      std::cout << "* ERROR : "<<e.GetErrorMessage()<<std::endl;
      return 1;
    }
    // JGRR & CM : this kills this never-ending process when it's supposed to! 
    std::cout << "bbRegeneratePackageDoc has finished normally. It will be aborted on purpose."<< std::endl; 
    abort();
    // EO JGRR CM
	return 0;
}
//==========================================================================


