/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#ifdef _USE_WXWIDGETS_

//==========================================================================
// WITH WX
//==========================================================================
#include "bbtkWxGUIScriptingInterface.h"

#include <wx/cmdline.h> 
#include <vector>


static const wxCmdLineEntryDesc cmdLineDesc[] =
{
  { wxCMD_LINE_PARAM,  NULL, NULL, _T("file1 [file2 [...]]"), wxCMD_LINE_VAL_STRING, wxCMD_LINE_PARAM_OPTIONAL }, 
  { wxCMD_LINE_SWITCH, _T("h"), _T("help"),   _T("Prints this help") },
  { wxCMD_LINE_SWITCH, _T("d"), _T("debug"),   _T("Message all 9") },
  { wxCMD_LINE_NONE }
};



class wxBBIApp : public wxApp
{
public:
  bool OnInit( );
  int  OnExit() { return true; }
  void OnInitCmdLine(wxCmdLineParser& parser);
  bool OnCmdLineParsed(wxCmdLineParser& parser);

  bool usage;
  std::vector<std::string> input_file;
};

IMPLEMENT_APP(wxBBIApp);

void wxBBIApp::OnInitCmdLine(wxCmdLineParser& parser)
{
  //    std::cout << "OnInitCmdLine"<<std::endl;
  parser.SetDesc(cmdLineDesc);
}

bool wxBBIApp::OnCmdLineParsed(wxCmdLineParser& parser)
{
  int argc = parser.GetParamCount();
  for (int i=0; i<argc; ++i) 
    {
      std::string s = bbtk::wx2std(parser.GetParam(i));
      input_file.push_back(s);
    }

  bool help = ( parser.Found(_T("h")) );
  usage = (help && (input_file.size()==0));
  if (usage) {
    std::cout << "bbStudio (The Black Box Development Studio) - bbtk "
	      << bbtk::GetVersion() << " - (c) Creatis 2007-2008"
	      << std::endl;
    parser.Usage();
  }
  else 
  {
	if ( parser.Found(_T("d")) )
	{
		bbtk::MessageManager::SetMessageLevel("all",9);
	}
  }


  return true;
}



// ----------------------------------------------------------------------------
// The `main program' equivalent, creating the windows and returning the
// main frame
bool wxBBIApp::OnInit( )
{
  //    std::cout << "OnInit"<<std::endl;
  wxApp::OnInit();
#ifdef __WXGTK__
  //See http://www.wxwindows.org/faqgtk.htm#locale
  setlocale(LC_NUMERIC, "C");
#endif
  if (usage) return false;
  
  bbtk::WxGUIScriptingInterface *I = 
    new bbtk::WxGUIScriptingInterface(0);
  SetTopWindow(I);  
  I->Show(true);

  std::vector<std::string>::const_iterator i;
  i=input_file.begin(); 
  if (i!=input_file.end()) I->Open(*i);

  return true;
}


#if defined(_WIN32) 

//  How to have a Console and wxWidgets
//  http://www.wxwidgets.org/wiki/index.php/MSVC_Setup_Guide
//   In Visual C++ 6 (7 should be similar), to create an application that is both a console application 
//  (cout's to the console are visible) and has a wxWidgets GUI, 
//  you need to use the linker option "/subsystem:console" and the following code:
int main(int argc, char* argv[])
{
	return WinMain(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), SW_SHOWNORMAL);
}

#endif // defined(_WIN32) 


#else
//==========================================================================
// WITHOUT WX
//==========================================================================
#include <iostream>
int main(int argc, char* argv[])
{  
  std::cout << "bbStudio was not compiled with wxWidgets : ciao !" <<std::endl;
  return 0;
}

// EOF
#endif //#ifdef _USE_WXWIDGETS_



