;/*
; # ---------------------------------------------------------------------
; #
; # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
; #                        pour la SantÈ)
; # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
; # Previous Authors : Laurent Guigues, Jean-Pierre Roux
; # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
; #
; #  This software is governed by the CeCILL-B license under French law and
; #  abiding by the rules of distribution of free software. You can  use,
; #  modify and/ or redistribute the software under the terms of the CeCILL-B
; #  license as circulated by CEA, CNRS and INRIA at the following URL
; #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
; #  or in the file LICENSE.txt.
; #
; #  As a counterpart to the access to the source code and  rights to copy,
; #  modify and redistribute granted by the license, users are provided only
; #  with a limited warranty  and the software's author,  the holder of the
; #  economic rights,  and the successive licensors  have only  limited
; #  liability.
; #
; #  The fact that you are presently reading this means that you have had
; #  knowledge of the CeCILL-B license and that you accept its terms.
; # ------------------------------------------------------------------------ */

;=============================================================================
; bbs-mode.el = Emacs major mode for editing bbi script files (.bbs).

; Add bbs listfile names to the mode list.
(setq auto-mode-alist
	  (append
	   '(("\\.bbs\\'" . bbs-mode))
	   auto-mode-alist))
; Note, add the above setq auto-mode-alist to your .emacs
; along with the following to have the mode loaded when
; a *.mac file is loaded in emacs.
; (autoload 'bbs-mode "bbs-mode.el" t)

; Default indentation increment.
(defvar bbs-tab-width 2)

; Define keyword highlighting.
(defconst bbs-font-lock-defaults
  (list
   (regexp-opt '(
		 "author"
		 "config"
		 "connect"
		 "define"
		 "delete"
		 "description"
		 "endefine"
		 "endpackage"
		 "exec"
		 "graph"
		 "help"
		 "include"
		 "input"
		 "load"
		 "message"
		 "new"
		 "output"
		 "package"
		 "print"
		 "quit"
		 "reset"
		 "set"
		 "unload"
		 "index"
		 "category"
		 "clear"
		 ) t )
   "Highlighting expressions for bbs mode.")
  )

; Define a variable to hold the syntax table.
(defvar bbs-mode-syntax-table nil "Syntax table for bbs-mode.")

; If bbs mode file is reloaded, we want the syntax table to be
; regenerated when bbs-mode is called.
(setq bbs-mode-syntax-table nil)

; Let users hook to bbs mode.
(defvar bbs-mode-hook nil)

; Mode startup function.
(defun bbs-mode ()
  "Major mode for editing bbtk script files (.bbs)."
  (interactive)
  (kill-all-local-variables)
  (setq major-mode 'bbs-mode)
  (setq mode-name "bbs")
  					; Create the syntax table
  (setq bbs-mode-syntax-table (make-syntax-table))
  (set-syntax-table bbs-mode-syntax-table)
  (modify-syntax-entry ?_  "w" bbs-mode-syntax-table)
  (modify-syntax-entry ?\(  "()" bbs-mode-syntax-table)
  (modify-syntax-entry ?\)  ")(" bbs-mode-syntax-table)
  (modify-syntax-entry ?# "<" bbs-mode-syntax-table)
  (modify-syntax-entry ?\n ">" bbs-mode-syntax-table)
  
					; Setup font-lock mode.
  (make-local-variable 'font-lock-defaults)
  (setq font-lock-defaults '(bbs-font-lock-defaults))

  ; Setup comment syntax.
  (make-local-variable 'comment-start)
  (setq comment-start "#")

  (run-hooks 'bbs-mode-hook))

; This file provides bbs-mode.
(provide 'bbs-mode)

