
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


#-----------------------------------------------------------------------------
# messages compilation options 
OPTION ( BBTK_COMPILE_MESSAGES         "Compile bbtk messages ?"         ON)
OPTION ( BBTK_COMPILE_DEBUG_MESSAGES   "Compile bbtk debug messages ?"   ON)
OPTION ( BBTK_COMPILE_WARNING_MESSAGES "Compile bbtk warning messages ?" ON)
OPTION ( BBTK_COMPILE_ERROR_MESSAGES   "Compile bbtk error messages ?"   ON)
#-----------------------------------------------------------------------------
OPTION(BUILD_APPLICATIONS "Build Applications (bbi, bbfy, ...)" ON)
OPTION(BUILD_BBS_APPLI_BINARIES "Build binaries for bbs applications of all packages" OFF)
##EED   SWITCH_ON_IF_BUILD_ALL(BUILD_BBS_APPLI_BINARIES)
#-----------------------------------------------------------------------------
OPTION(BUILD_BBTK_DOC "Build documentation for bbtk." OFF)
SWITCH_ON_IF_BUILD_ALL(BUILD_BBTK_DOC)
#-----------------------------------------------------------------------------
IF(BUILD_BBTK_DOC)

  OPTION(BUILD_BBTK_DOC_PACKAGE 
    "Build bbtk packages documentation (bbi+dot)."       ON)
  OPTION(BUILD_BBTK_DOC_DOXYGEN 
    "Build doxygen documentation (doxygen)."             ON)
  OPTION(BUILD_BBTK_DOC_GUIDES_PDF 
    "Build bbtk Guides', PDF format (latex)."            ON)
  OPTION(BUILD_BBTK_DOC_GUIDES_HTML 
    "Build bbtk Guides', HTML format (latex+tth)."       OFF)

ELSE(BUILD_BBTK_DOC)
  
  IF(BUILD_BBTK_DOC_PACKAGE)
    SET(BUILD_BBTK_DOC_PACKAGE OFF CACHE BOOL 
      "Build bbtk packages documentation (bbdoc+dot)."	FORCE)
  ENDIF(BUILD_BBTK_DOC_PACKAGE)
  IF(BUILD_BBTK_DOC_DOXYGEN)
    SET(BUILD_BBTK_DOC_DOXYGEN OFF CACHE BOOL 
      "Build doxygen documentation. (doxygen)"		FORCE)
  ENDIF(BUILD_BBTK_DOC_DOXYGEN)
  
  IF(BUILD_BBTK_DOC_GUIDES_PDF)
    SET(BUILD_BBTK_DOC_GUIDES_PDF OFF CACHE BOOL 
      "Build bbtk Guides', PDF format (latex)."	FORCE)
  ENDIF(BUILD_BBTK_DOC_GUIDES_PDF)
  
  IF(BUILD_BBTK_DOC_GUIDES_HTML)
    SET(BUILD_BBTK_DOC_GUIDES_HTML OFF CACHE BOOL 
      "Build bbtk Guides', HTML format (latex tth)."		FORCE)
  ENDIF(BUILD_BBTK_DOC_GUIDES_HTML)
#  IF(BUILD_BBTK_DOC_SCRIPTS)
#    SET(BUILD_BBTK_DOC_SCRIPTS_HTML OFF CACHE BOOL 
#      "Build bbtk scripts documentation (bbi+dot)."		FORCE)
#  ENDIF(BUILD_BBTK_DOC_SCRIPTS)
  
ENDIF(BUILD_BBTK_DOC)
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# BOOST C++
#SET(BBTK_SHIPPED_BOOST boost_1_35_0 CACHE INTERNAL "Shipped boost dir" FORCE)
#OPTION(BBTK_USE_SHIPPED_BOOST 
#  "Use the shipped boost C++ library (${BBTK_SHIPPED_BOOST})" ON)
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
OPTION(BBTK_USE_WXWIDGETS "Build bbtk with wxWidgets ?" OFF)
IF(BBTK_USE_WXWIDGETS)
  SET(USE_WXWIDGETS ON CACHE BOOL "Use WxWidgets" FORCE)
ELSE(BBTK_USE_WXWIDGETS)
  SET(USE_WXWIDGETS OFF CACHE BOOL "Use WxWidgets" FORCE)
ENDIF(BBTK_USE_WXWIDGETS)
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# LG 25/05/09 : KW NOT SUPPORTED ANYMORE
#OPTION(BBTK_USE_KWWIDGETS "Build bbtk with KWWidgets ?" OFF)
IF (BBTK_USE_KWWIDGETS)
  SET(USE_KWWIDGETS ON CACHE BOOL "Use KWWidgets" FORCE)
ELSE (BBTK_USE_KWWIDGETS)
  SET(USE_KWWIDGETS OFF CACHE BOOL "Use KWWidgets" FORCE)
ENDIF (BBTK_USE_KWWIDGETS)
#SWITCH_ON_IF_BUILD_ALL(BBTK_USE_KWWIDGETS)
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
OPTION(BBTK_USE_QT "Build bbtk with QT ?" OFF)
IF (BBTK_USE_QT)
  SET(USE_QT4 ON CACHE BOOL "Use QT" FORCE)
ELSE (BBTK_USE_QT)
  SET(USE_QT4 OFF CACHE BOOL "Use QT" FORCE)
ENDIF (BBTK_USE_QT)
# CM Commented to avoid a bug with latest Boost version
# SWITCH_ON_IF_BUILD_ALL(BBTK_USE_QT)
# SWITCH_ON_IF_BUILD_ALL(BBTK_USE_QT)
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
IF(USE_ITK)
  IF(ITK_FOUND)
    MESSAGE(STATUS "")
    MESSAGE(STATUS "=======================================")
    MESSAGE(STATUS "Resolving ITK images options...")
    # images compilation option 
    OPTION ( itk_IMAGE_DIM_2 "itk : Compile 2D images" ON)
    OPTION ( itk_IMAGE_DIM_3 "itk : Compile 3D images" ON)
    OPTION ( itk_IMAGE_DIM_4 "itk : Compile 4D images" ON)
    OPTION ( itk_IMAGE_TYPE_CHAR "itk : Compile char images" ON)
    OPTION ( itk_IMAGE_TYPE_UCHAR "itk : Compile unsigned char images" ON)
    OPTION ( itk_IMAGE_TYPE_SHORT "itk : Compile short images" ON)
    OPTION ( itk_IMAGE_TYPE_USHORT "itk : Compile unsigned short images" ON)
    OPTION ( itk_IMAGE_TYPE_INT "itk : Compile int images" ON)
    OPTION ( itk_IMAGE_TYPE_UINT "itk : Compile unsigned int images" ON)
    OPTION ( itk_IMAGE_TYPE_FLOAT "itk : Compile float images" ON)
    OPTION ( itk_IMAGE_TYPE_DOUBLE "itk : Compile double images" ON)
    
    IF ( itk_IMAGE_DIM_2 ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_DIM_2 )
    ENDIF ( itk_IMAGE_DIM_2 )
    
    IF ( itk_IMAGE_DIM_3 ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_DIM_3 )
    ENDIF ( itk_IMAGE_DIM_3 )
    
    IF ( itk_IMAGE_DIM_4 ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_DIM_4 )
    ENDIF ( itk_IMAGE_DIM_4 )

    IF ( itk_IMAGE_TYPE_CHAR ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_TYPE_int8_t )
    ENDIF ( itk_IMAGE_TYPE_CHAR )

    IF ( itk_IMAGE_TYPE_UCHAR ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_TYPE_uint8_t )
    ENDIF ( itk_IMAGE_TYPE_UCHAR )
    
    IF ( itk_IMAGE_TYPE_SHORT ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_TYPE_int16_t )
    ENDIF ( itk_IMAGE_TYPE_SHORT )
    
    IF ( itk_IMAGE_TYPE_USHORT ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_TYPE_uint16_t )
    ENDIF ( itk_IMAGE_TYPE_USHORT )
    
    IF ( itk_IMAGE_TYPE_INT ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_TYPE_int32_t )
    ENDIF ( itk_IMAGE_TYPE_INT )
    
    IF ( itk_IMAGE_TYPE_UINT ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_TYPE_uint32_t )
    ENDIF ( itk_IMAGE_TYPE_UINT )
    
    IF ( itk_IMAGE_TYPE_FLOAT ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_TYPE_float )
    ENDIF ( itk_IMAGE_TYPE_FLOAT )
    
    IF ( itk_IMAGE_TYPE_DOUBLE ) 
      CREA_DEFINE( BBTK_ITK_IMAGE_TYPE_double )
    ENDIF ( itk_IMAGE_TYPE_DOUBLE )
    MESSAGE(STATUS "=======================================")

  ENDIF(ITK_FOUND)
ENDIF(USE_ITK)
#-----------------------------------------------------------------------------

