 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#----------------------------------------------------------------------------
# BINARY DIR MUST BE IN INCLUDE DIRS 
# TO FIND .h OF AUTOMATICALLY GENERATED FILES (e.g. FROM XML)
INCLUDE_DIRECTORIES( ${PROJECT_BINARY_DIR}/kernel/src ) 
# SOURCES DIR MUST ALSO BE IN INCLUDE DIRS FOR FILES COMPILED IN BINARY DIR 
# WHICH NEED TO INCLUDE OTHER FILES OF THE PACKAGE
INCLUDE_DIRECTORIES( ${PROJECT_SOURCE_DIR}/kernel/src )
INCLUDE_DIRECTORIES( ${PROJECT_SOURCE_DIR}/kernel/src/ThirdParty )
#----------------------------------------------------------------------------

#----------------------------------------------------------------------------
# THE PACKAGES ARE CORE ONES
SET(BBTK_CORE_PACKAGE TRUE)
#----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# Path for binaries 
IF(WIN32) # OR APPLE)
  SET (EXECUTABLE_OUTPUT_REL_PATH "") 
  SET (LIBRARY_OUTPUT_REL_PATH    "")
  IF(WIN32)
	SET (ADDITIONAL_DLL_PATH "C:/Program Files/CreaTools/crea_ThirdParty_dlls-3.0.0/bin" CACHE PATH "Additional paths in which to look for dlls")
  ENDIF(WIN32)
ELSE(WIN32) # OR APPLE)
  SET (EXECUTABLE_OUTPUT_REL_PATH bin) 
  SET (LIBRARY_OUTPUT_REL_PATH    bin)
ENDIF(WIN32) # OR APPLE)  

SET (EXECUTABLE_OUTPUT_PATH 
  ${PROJECT_BINARY_DIR}/${EXECUTABLE_OUTPUT_REL_PATH})
SET (LIBRARY_OUTPUT_PATH    
  ${PROJECT_BINARY_DIR}/${LIBRARY_OUTPUT_REL_PATH})
#-----------------------------------------------------------------------------



#-----------------------------------------------------------------------------
# The var BBTK_BIN_PATH
# gives the system-dependent path to output binaries
# BBTK_BBI, BBTK_BBFY and BBTK_BBDOC 
# point to the system-dependent applications 
# (.exe on win / no extension on lin) 
# WARNING : 
# On WIN32, these paths will only be right at *BUILD TIME* in VS6 or .net
# Cannot be used at cmake run time !

SET(BBTK_LIB_PATH ${CMAKE_CREA_LIB_PATH} )

IF(WIN32)
  IF(MSVC10)  #FCY 18-06-10
	  SET(BBTK_BIN_PATH $(OutDir))
  ELSE(MSVC10)
	  IF(CMAKE_GENERATOR STREQUAL "Visual Studio 6")
	    SET(BBTK_BIN_PATH ${EXECUTABLE_OUTPUT_PATH}/$(IntDir))
	  ELSE(CMAKE_GENERATOR STREQUAL "Visual Studio 6")
	    SET(BBTK_BIN_PATH $(SolutionDir)/$(OutDir))
	  ENDIF(CMAKE_GENERATOR STREQUAL "Visual Studio 6")
  ENDIF(MSVC10)
  SET(BBTK_BBS2CPP ${BBTK_BIN_PATH}/bbs2cpp.exe)
  SET(BBTK_BBC ${BBTK_BIN_PATH}/bbc.exe)
  SET(BBTK_BBI ${BBTK_BIN_PATH}/bbi.exe)
  SET(BBTK_BBFY ${BBTK_BIN_PATH}/bbfy.exe)
  SET(BBTK_BBPCONFIGURATOR ${BBTK_BIN_PATH}/bbpConfigurator.exe)

ELSE(WIN32)
# For Xcode : have to test the cmake generator !
  IF ( CMAKE_GENERATOR STREQUAL Xcode)
    SET(BBTK_BIN_PATH ${EXECUTABLE_OUTPUT_PATH}/Debug)
  ELSE(CMAKE_GENERATOR STREQUAL Xcode)
    SET(BBTK_BIN_PATH ${EXECUTABLE_OUTPUT_PATH})
  ENDIF(CMAKE_GENERATOR STREQUAL Xcode) 
  SET(BBTK_BBI ${BBTK_BIN_PATH}/bbi)
  SET(BBTK_BBS2CPP ${BBTK_BIN_PATH}/bbs2cpp)
  SET(BBTK_BBC ${BBTK_BIN_PATH}/bbc)
  SET(BBTK_BBFY ${BBTK_BIN_PATH}/bbfy)
  SET(BBTK_BBPCONFIGURATOR ${BBTK_BIN_PATH}/bbpConfigurator)
ENDIF(WIN32)  
SET(BBTK_PACKAGE_LIB_PATH ${BBTK_LIB_PATH})

MESSAGE(STATUS "")
MESSAGE(STATUS "===============================================")
MESSAGE(STATUS "Setting up base pathes:")
MESSAGE(STATUS "* BBTK_BIN_PATH         =${BBTK_BIN_PATH}")
MESSAGE(STATUS "* BBTK_LIB_PATH         =${BBTK_LIB_PATH}")
MESSAGE(STATUS "* BBTK_PACKAGE_LIB_PATH =${BBTK_PACKAGE_LIB_PATH}")
MESSAGE(STATUS "* BBTK_BBI              =${BBTK_BBI}")
MESSAGE(STATUS "* BBTK_BBS2CPP          =${BBTK_BBS2CPP}")
MESSAGE(STATUS "* BBTK_BBC              =${BBTK_BBC}")
MESSAGE(STATUS "* BBTK_BBFY             =${BBTK_BBFY}")
MESSAGE(STATUS "* BBTK_BBPCONFIGURATOR  =${BBTK_BBPCONFIGURATOR}")
#-----------------------------------------------------------------------------

#-----------------------------------------------------------------------------
# The vars BBTK_DOC_REL_PATH and BBTK_BBS_REL_PATH
# store documentation and scripts **RELATIVE** paths  
# from build tree root or install tree root
# (different on win/lin)
IF(WIN32)
  # A trick to install in root install dir (problem when empty path given)
  SET(BBTK_SHARE_REL_PATH "bin/..")
  SET(BBTK_DOC_REL_PATH doc)
  SET(BBTK_BBS_REL_PATH bbs)
  SET(BBTK_DATA_REL_PATH data)
ELSE(WIN32)
  SET(BBTK_SHARE_REL_PATH share/bbtk)
  SET(BBTK_DOC_REL_PATH share/bbtk/doc)
  SET(BBTK_BBS_REL_PATH share/bbtk/bbs)
  SET(BBTK_DATA_REL_PATH share/bbtk/data)
ENDIF(WIN32)   

MESSAGE(STATUS "* BBTK_SHARE_REL_PATH   =${BBTK_SHARE_REL_PATH}")
MESSAGE(STATUS "* BBTK_DOC_REL_PATH     =${BBTK_DOC_REL_PATH}")
MESSAGE(STATUS "* BBTK_BBS_REL_PATH     =${BBTK_BBS_REL_PATH}")
MESSAGE(STATUS "* BBTK_DATA_REL_PATH    =${BBTK_DATA_REL_PATH}")
MESSAGE(STATUS "===============================================")

#-----------------------------------------------------------------------------
