# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */


BUILDIR=bbtk-build-tmp
HTMLDIR=/var/www/html/software/bbtk
CVSR=:pserver:${USER}@cvs.creatis.insa-lyon.fr:/cvs/creatis
TAG=$1

echo "===== EXECUTING maj_bbtk_tux.sh ====="
echo "BUILDIR = ${BUILDIR}"
echo "HTMLDIR = ${HTMLDIR}"
echo "CVSROOT = ${CVSR}"
echo "TAG     = ${TAG}"

rm -Rf ${BUILDIR}
mkdir ${BUILDIR}
cd ${BUILDIR}
pwd


cvs -d ${CVSR} export -r ${TAG} bbtk

tar zcvf bbtk_${TAG}.tgz bbtk
zip -r bbtk_${TAG}.zip bbtk

mkdir bin
cd bin
export CC='gcc'
export CXX='g++'
cmake ../bbtk -D--BUILD_ALL=ON 
cmake ../bbtk -D--BUILD_ALL=ON 
cmake ../bbtk -D--BUILD_ALL=ON 
cmake ../bbtk -D--BUILD_ALL=ON 
cmake ../bbtk -D--BUILD_ALL=ON 
cmake ../bbtk -D--BUILD_ALL=ON 
make
cd ../bin/share/bbtk/doc
tar zcvf bbtk-site.tgz *
scp bbtk-site.tgz tux:${HTMLDIR}
cd ../../../..
scp bbtk_${TAG}.tgz tux:${HTMLDIR}
scp bbtk_${TAG}.zip tux:${HTMLDIR}
ssh tux "cd ${HTMLDIR};tar zxvf bbtk-site.tgz"

