/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkBlackBox.cxx,v $
  Language:  C++
  Date:      $Date: 2009/05/18 10:45:40 $
  Version:   $Revision: 1.45 $
=========================================================================*/



/**
 *  \file 
 *  \brief Class bbtk::WxInterfaceEditorGraphicBBS . 
 */


#include "bbtkwxGUIEditorGraphicBBS.h"
#include "bbtkwxGUIEditorGraphicContainer.h"


namespace bbtk
{


  //=========================================================================
	wxGUIEditorGraphicBBS::wxGUIEditorGraphicBBS(wxFrame *parent)
    : wxFrame(parent, -1, _T("bbEditor"),wxDefaultPosition, wxSize(1200,800))
  {
	  m_mgr.SetManagedWindow(this);
	  editorgraphiccontainer = new wxGUIEditorGraphicContainer(this);
	  
	  wxPanel *mWxGUIGrapphicEditorPanel = new wxPanel(this,-1);
	  wxPanel *mWxGUIBoxBrowserPanel = new wxPanel(this,-1);
	  wxPanel *mWxGUIConfigurationGraphicEditorPanel = new wxPanel(this,-1);
	  
	  mWxGUIGrapphicEditorPanel->SetBackgroundColour( wxColor(255,0,0) );
	  mWxGUIBoxBrowserPanel->SetBackgroundColour( wxColor(0,255,0) );
	  mWxGUIConfigurationGraphicEditorPanel->SetBackgroundColour( wxColor(255,0,255) );
	  
	  //
	  m_mgr.AddPane(mWxGUIGrapphicEditorPanel,
					wxAuiPaneInfo().Name(wxT("graphic_editor_content"))
					.Caption(wxT("Graphic editor"))
					.MinimizeButton(true)
					.MaximizeButton(true)
					.Center()
					.MinSize(wxSize(100,100))
					);   
	  
	  m_mgr.AddPane(mWxGUIBoxBrowserPanel,
					wxAuiPaneInfo().Name(wxT("box_browser_content"))
					.Caption(wxT("Box browser"))
					.MinimizeButton(true)
					.MaximizeButton(true)
					.Right()
					.Layer(2)
					.MinSize(wxSize(400,100))
					);
	  
	  m_mgr.AddPane(mWxGUIConfigurationGraphicEditorPanel,
					wxAuiPaneInfo().Name(wxT("configuration_graphic_editor_content"))
					.Caption(wxT("Messages"))
					.MinimizeButton(true)
					.MaximizeButton(true)
					.Bottom()
					.MinSize(wxSize(100,100))
					);
	  
	  SetAutoLayout(true);
	  Layout();
	  m_mgr.Update();
	  
  }

  //=========================================================================
  wxGUIEditorGraphicBBS::~wxGUIEditorGraphicBBS()
  {
	  delete editorgraphiccontainer;
	  m_mgr.UnInit();
  }
  //=========================================================================



}  // EO namespace bbtk

// EOF

