/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//---------------------------------------------------------------------------
// $RCSfile: TreeMultiItemBase.cpp,v $
// $Source: /cvs/creatis/bbtk/kernel/src/ThirdParty/wx/treemultictrl/TreeMultiItemBase.cpp,v $
// $Revision: 1.2 $
// $Date: 2012/11/16 08:49:16 $
//---------------------------------------------------------------------------
// Author:      Jorgen Bodde
// Copyright:   (c) Jorgen Bodde
// License:     wxWidgets License
//---------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "TreeMultiItemBase.cpp"
#endif

/* for compilers that support precompilation
   includes "wx/wx.h" */

#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#include "wx/treemultictrl/TreeMultiItemBase.h"
#include "wx/treemultictrl/TreeMultiItemNode.h"

/** TreeMultiItemBase
  * This class is the node of the whole tree. All the other classes in the
  * tree descend from this node. It contains the type of the class without
  * using RTTI. NOTE: this class cannot be constructed directly
  */

TreeMultiItemBase::TreeMultiItemBase(TreeMultiItemNode *parent)
	: _excluded(false)

	, _x(0)
	, _y(0)
        , _width(0)
        , _height(0)
        , _parent(parent)
        , m_Selected(false)
#if(CHECKBOXVIEW)
        , _checkbox(false)
        , _checkboxState(0)
#endif
{
    // TODO: Enter your constructor code here
}

TreeMultiItemBase::~TreeMultiItemBase()
{
    // TODO: Enter your destructor code here
}

bool TreeMultiItemBase::IsVisible()
{
	// are we excluded? then we are not visible as well

	if(IsExcluded())
		return false;

	// check every parent up until the last and if one of them is collapsed
	// we are not visible

	TreeMultiItemNode *p = GetParent();
	while(p)
	{
		if(!p->IsExpanded())
			return false;
		else
			p = p->GetParent();
	}

	return true;
}
