/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//---------------------------------------------------------------------------
// $RCSfile: TreeMultiItemBase.h,v $
// $Source: /cvs/creatis/bbtk/kernel/src/ThirdParty/wx/treemultictrl/TreeMultiItemBase.h,v $
// $Revision: 1.2 $
// $Date: 2012/11/16 08:49:16 $
//---------------------------------------------------------------------------
// Author:      Jorgen Bodde
// Copyright:   (c) Jorgen Bodde
// License:     wxWidgets License
//---------------------------------------------------------------------------

#ifndef __TREEMULTIITEMBASE_HPP_
#define __TREEMULTIITEMBASE_HPP_

#ifdef __GNUG__
    #pragma interface "TreeMultiItemBase.cpp"
#endif

#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

// forward definitions
class TreeMultiItemRoot;
class TreeMultiItemWindow;
class TreeMultiItemNode;

class TreeMultiItemBase
{
protected:
	TreeMultiItemBase(TreeMultiItemNode *parent);

	/** Name property of this item, useful for assigning / coupling
	    external variable reference to this item. It is not mandatory */
	wxString _name;

	/** Flag to indicate that this node is visible or not. The Node can be 
	    temporarily excluded by flagging it. This has also consequences for all 
		the children of this node (if any) */
	bool _excluded;

	/** Type of instanced class */
	int _type;

	/** Calculated X, Y position */
	int _x, _y;

	/** Calculated width, height */
	int _width, _height;
	
#if(CHECKBOXVIEW)
	/** Checkbox flag (draw one or not) */
	bool _checkbox;
	
	/** Internal draw state. This is a unintelligent state, and should be
	    updated when this node has some checked and some unchecked children
		then this should become a tri-stated item */
	int _checkboxState;
#endif

public:
	virtual ~TreeMultiItemBase();

	// type of tree item

    int GetType() const { return _type; };
	TreeMultiItemNode *GetParent() const { return _parent; };

	/** Get name of this node */
        wxString GetName() const {
                return _name;
        };
 /** Set name of the item */
  void SetName(wxString const& NewName)
  {
    this->_name = NewName;
  }

        /** returns the instance pointer if the current node is
        a TreeMultiItemRoot, and NULL when it's not.
	*/
	virtual TreeMultiItemRoot *IsTreeMultiItemRoot() const {
		return 0;
	};

    /** returns the instance pointer if the current node is
        a TreeMultiItemWindow, and NULL when it's not.
	*/
	virtual TreeMultiItemWindow *IsTreeMultiItemWindow() const {
		return 0;
	};

    /** returns the instance pointer if the current node is
        a TreeMultiItemNode, and NULL when it's not.
	*/
	virtual TreeMultiItemNode *IsTreeMultiItemNode() const {
		return 0;
	};

	/** Sets or resets the excluded flag. When excluded node is not visible */
	void SetExcluded(bool excluded) {
		_excluded = excluded;
	};

	/** Get / Set routine for X */
	void SetX(int x) {
		_x = x;
	};

	int GetX() const {
		return _x;
	};

	/** Get / Set routine for Y */
	void SetY(int y) {
		_y = y;
	};

	int GetY() const {
		return _y;
	};

	/** Get / Set routine for height */
	void SetHeight(int height) {
		_height = height;
	};

	int GetHeight() const {
		return _height;
	};

	/** Get / Set routine for width */
	void SetWidth(int width) {
		_width = width;
	};

	int GetWidth() const {
		return _width;
	};

	/** Returns true when this item is drawn somewhere in the
	    tree. Whenever a parent of this node is collapsed, it
	    is not visible and it is not necessary to perform i.e.
	    redraw actions. 
		
		It also returns false when this node is excluded from the
		tree. 
		
		\sa wxTreeMultiCtrl::Exclude(), wxTreeMultiCtrl::Include())
	*/
	bool IsVisible();

	/* Returns if this node is excluded from the tree. If this item
	   is a Node, then all kids are excluded as well */
	bool IsExcluded() const {
                return _excluded;
        };
        
 //
 // item selection status handling
 
 /** checks if the item is selected */
  bool IsSelected(void) const
  {
    return this->m_Selected;
  }

 /** mark the current item as selected */
  void Select(void)
  {
    this->m_Selected = true;
  }
  
 /** toggle the selection status */
  void ToggleSelection(void)
  {
    this->m_Selected = !(this->m_Selected);
  }

 /** unmark the item */
  void Unselect(void)
  {
    this->m_Selected = false;
  }

#if(CHECKBOXVIEW)
        /** Sets checkbox or not. This does not influence the state of the checkbox */
        void SetCheckbox(bool value) {
		_checkbox = value;
	};

	/** Returns current state of the checkbox view */
	bool GetCheckbox() const {
		return _checkbox;
	};

	/** Sets checkbox state. If 0 it's unchecked, 1 = checked and 2 = tristate */
	virtual void SetCheckboxState(int state) {
		wxCHECK2(state < 3 && state >= 0, return);
		_checkboxState = state;
	};

	/** Returns current state of checkbox */
	int GetCheckboxState() const {
		return _checkboxState;
	};
#endif

private:
        TreeMultiItemNode *_parent;
        
 // flags to indicate the status of the item:
  bool m_Selected;
};

#endif

