/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//---------------------------------------------------------------------------
// $RCSfile: TreeMultiItemNode.cpp,v $
// $Source: /cvs/creatis/bbtk/kernel/src/ThirdParty/wx/treemultictrl/TreeMultiItemNode.cpp,v $
// $Revision: 1.2 $
// $Date: 2012/11/16 08:49:16 $
//---------------------------------------------------------------------------
// Author:      Jorgen Bodde
// Copyright:   (c) Jorgen Bodde
// License:     wxWidgets License
//---------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "TreeMultiItemNode.cpp"
#endif

/* for compilers that support precompilation
   includes "wx/wx.h" */

#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#include "wx/treemultictrl/TreeMultiItemNode.h"

#include "wx/arrimpl.cpp"
WX_DEFINE_OBJARRAY(TreeMultiItemBaseArray);

/** TreeMultiItemNode
  * This class is a container holder for multiple TreeMultiItemBase classes.
  * Since both a TreeMultiItemNode and a TreeMultiItemWindow are a descendant
  * from a TreeMultiItemBase class, it can hold multiple of these.
  * In the case of a directory tree structure, it can hold multiple
  * directories, and leafs (files).
  */

// default constructor for container composite
TreeMultiItemNode::TreeMultiItemNode(TreeMultiItemNode *parent, const wxString &caption, const wxString &name)
	: TreeMultiItemBase(parent)
	, _caption(caption)
	, _nodeExpanded(true)

{
	_name = name;
	Clear();
}

//------------------------------------------------------------

TreeMultiItemNode::~TreeMultiItemNode()
{
    // delete all items on this level
    Clear();
}

//------------------------------------------------------------

void TreeMultiItemNode::AddNode(TreeMultiItemBase *node)
{
	if(node)
                _items.Add(node);
}

void TreeMultiItemNode::InsertNode(TreeMultiItemBase* NodePtr, size_t Position)
{
        if (NodePtr != NULL)
                this->_items.Insert(NodePtr,Position);
}

//------------------------------------------------------------

void TreeMultiItemNode::DeleteNode(TreeMultiItemBase *node)
{
	// this is wrong. The RemoveAt and Remove should delete
	// the object
	if(node)
	{
		_items.Detach(Index(node));
		delete node;
	}

}

//------------------------------------------------------------

void TreeMultiItemNode::DeleteNode(int index)
{
	// this is wrong. The RemoveAt and Remove should delete
	// the object
	if(index < (int)_items.Count() && index >= 0)
		_items.RemoveAt(index);
}

//------------------------------------------------------------

int TreeMultiItemNode::GetNodeCount() const
{
	return _items.Count();
}

//------------------------------------------------------------

TreeMultiItemBase *TreeMultiItemNode::GetNode(int index) const
{
	TreeMultiItemBase *value = 0;

	if(index < (int)_items.Count() && index >= 0)
		value = &_items.Item(index);

	return value;
}

//------------------------------------------------------------

TreeMultiItemBase *TreeMultiItemNode::RemoveNode(TreeMultiItemBase *node)
{
	if(node)
		_items.Detach(_items.Index(*node));

	return node;
}

//------------------------------------------------------------

TreeMultiItemBase * TreeMultiItemNode::RemoveNode(int index)
{
	TreeMultiItemBase *value = 0;

	if(index < (int)_items.Count() && index > 0)
	{
		value = &_items.Item(index);
		_items.Detach(index);
	}

	return value;
}

//------------------------------------------------------------

int TreeMultiItemNode::Index(TreeMultiItemBase *node,  bool searchFromEnd) const
{
	wxCHECK(node, -1);

	return _items.Index(*node, searchFromEnd);
}

//------------------------------------------------------------

void  TreeMultiItemNode::Clear()
{
	_items.Clear();
}

//------------------------------------------------------------

TreeMultiItemBase * TreeMultiItemNode::GetNodeNext(int &cookie) const
{
	TreeMultiItemBase *value = 0;

	if(cookie >= 0 && cookie < (int)_items.Count())
	{
		value = &_items[cookie];
		cookie++;
	}

	return value;
}

//------------------------------------------------------------

TreeMultiItemBase* TreeMultiItemNode::First() const
{
  if (this->_items.GetCount() > 0)
    return &(this->_items[0]);
  else
    return NULL;
} /* TreeMultiItemNode::First() const */

TreeMultiItemBase* TreeMultiItemNode::Last() const
{
        if(this->_items.GetCount() > 0)
          return &(this->_items.Last());
        else
          return NULL;
} /* TreeMultiItemNode::Last() const */

