/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//---------------------------------------------------------------------------
// $RCSfile: TreeMultiItemWindow.cpp,v $
// $Source: /cvs/creatis/bbtk/kernel/src/ThirdParty/wx/treemultictrl/TreeMultiItemWindow.cpp,v $
// $Revision: 1.2 $
// $Date: 2012/11/16 08:49:16 $
//---------------------------------------------------------------------------
// Author:      Jorgen Bodde
// Copyright:   (c) Jorgen Bodde
// License:     wxWidgets License
//---------------------------------------------------------------------------

#ifdef __GNUG__
    #pragma implementation "TreeMultiItemWindow.cpp"
#endif

/* for compilers that support precompilation
   includes "wx/wx.h" */

#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#include "wx/treemultictrl/TreeMultiItemWindow.h"

/** TreeMultiItemWindow
  *	This class is a possible end node for the tree. If you want multiple
  *	types of end-nodes you should copy this file and adjust it with a 
  *	different class name.
  */

TreeMultiItemWindow::TreeMultiItemWindow(TreeMultiItemNode *parent, const wxString &name)
	:  TreeMultiItemBase(parent)
	, _window(0)
	, _topSpacing(0)
	, _frontSpacing(0)
	, _span(false)
{
    _name = name;

	// TODO: Enter your constructor code here
}

TreeMultiItemWindow::~TreeMultiItemWindow()
{
	if(_window)
		_window->Destroy();
}

void TreeMultiItemWindow::AssignWindow(wxWindow *wnd)
{
	// delete previous, assign new (even if zero)
	if(_window)
		_window->Destroy();

	_window = wnd;

	// recalculate the size
	if(wnd)
	{
		wxSize size; 

		// resize the sized control by sizer or 
		// by single window. For a sizer handled window
		// GetBestSize returns the optimal size

		/// \todo This might need rivision for retaining the sizer size
		/// maybe we need to check whether size is <> 0,0 before get best size

		if(wnd->GetSizer())
			size = wnd->GetBestSize();
		else
			size = wnd->GetSize();

		_height = size.GetHeight();
		_width = size.GetWidth();

	}
	else
	{
		_height = 0;
		_width = 0;
	}
}

#if(CHECKBOXVIEW)

void TreeMultiItemWindow::SetCheckboxState(int state) {
	TreeMultiItemBase::SetCheckboxState(state);

	// enable or disable the window
	if(GetCheckbox() && GetWindow() && state != 2)
		GetWindow()->Enable(state == 1);
};

#endif // #if(CHECKBOXVIEW)
