/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


//---------------------------------------------------------------------------
// $RCSfile: TreeMultiItemWindow.h,v $
// $Source: /cvs/creatis/bbtk/kernel/src/ThirdParty/wx/treemultictrl/TreeMultiItemWindow.h,v $
// $Revision: 1.2 $
// $Date: 2012/11/16 08:49:16 $
//---------------------------------------------------------------------------
// Author:      Jorgen Bodde
// Copyright:   (c) Jorgen Bodde
// License:     wxWidgets License
//---------------------------------------------------------------------------

#ifndef __TREEMULTIITEMWINDOW_HPP_
#define __TREEMULTIITEMWINDOW_HPP_

#ifdef __GNUG__
    #pragma interface "TreeMultiItemWindow.cpp"
#endif

#ifndef WX_PRECOMP
    #include "wx/wx.h"
#endif

#include <wx/dynarray.h>

#include "TreeMultiItemBase.h"

class TreeMultiItemWindow : public TreeMultiItemBase
{
private:
	/** The simple control, or complex sizer that represents this window
		in the TreeMultiCtrl */
	wxWindow *_window;

	/** Top and front extra spacings, added to X, Y */
	int _topSpacing, _frontSpacing;

	/** Spanning flag */
	bool _span;

public:
	TreeMultiItemWindow(TreeMultiItemNode *parent, const wxString &name = wxEmptyString);
	virtual ~TreeMultiItemWindow();

	// IsClass method
	virtual TreeMultiItemWindow *IsTreeMultiItemWindow() const {
		return (TreeMultiItemWindow *)this;
	};
	
	/** Assigns the given window to this TreeMultiItemWindow, and also destroys the 
		present window. If the assigned window is 0, this item is not drawn
		and removed from the tree visually */
	void AssignWindow(wxWindow *wnd);

	/** Get window method */
	wxWindow *GetWindow() {
		return _window;
	};

	/* Sets front spacing */
	void SetFrontSpacing(int frontSpacing) {
		_frontSpacing = frontSpacing;
	};
	/* Gets front spacing */
	int GetFrontSpacing() const {
		return _frontSpacing;
	};
	/* Sets top spacing */
	void SetTopSpacing(int topSpacing) {
		_topSpacing = topSpacing;
	};
	/* Gets top spacing */
	int GetTopSpacing() const {
		return _topSpacing;
	};
	
	/* Sets horizontal span, meaning when this is set the window
	   attached may be resized horizontally when the window is resized */
	void SetHorizontalSpan(bool span) {
		_span = span;
	};

	/* Sets horizontal span, meaning when this is set the window
	   attached may be resized horizontally when the window is resized */
	bool GetHorizontalSpan() const {
		return _span;
	};

#if(CHECKBOXVIEW)
	/** Inherited from base, to enable or disable window */
	virtual void SetCheckboxState(int state);
#endif
};

#endif

