/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#include "wx/treemultictrl/wxTreeMultiEvent.h"


// constructors / destructor:
wxTreeMultiEvent::wxTreeMultiEvent(wxEventType InitEventType, wxTreeMultiItem const& InitItem)
                 :wxNotifyEvent(InitEventType), m_Item(InitItem)
{
} /* wxTreeMultiEvent::wxTreeMultiEvent(wxEventType, wxTreeMultiItem const&) */

// inherited functions:
// wxEvent:
// cloning:

// class identification:

IMPLEMENT_DYNAMIC_CLASS(wxTreeMultiEvent, wxNotifyEvent)

// event types:
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_BEGIN_DRAG)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_BEGIN_RDRAG)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_BEGIN_LABEL_EDIT)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_END_LABEL_EDIT)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_DELETE_ITEM)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_GET_INFO)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_SET_INFO)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_EXPANDED)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_EXPANDING)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_COLLAPSED)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_COLLAPSING)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_SEL_CHANGED)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_SEL_CHANGING)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_KEY_DOWN)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_ACTIVATED)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_RIGHT_CLICK)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_MIDDLE_CLICK)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_END_DRAG)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_STATE_IMAGE_CLICK)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_GETTOOLTIP)
DEFINE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_MENU)

