/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */



#ifndef wxtreemultievent_header
#define wxtreemultievent_header

#include "wx/event.h"

#include "wx/treemultictrl/wxTreeMultiCtrl.h"


/**
   \section treemultievent Event handlers for wxTreeMultiCtrl
   
   Event handlers for wxTreeMultiCtrl are similar to wxTreeEvents. But they are
   optimized for the wxTreeMultiCtrl class.
*/

class /*WXDLLEXPORT*/ wxTreeMultiEvent : public wxNotifyEvent
{
public:
 ///
 /// The default constructor
 ///
  wxTreeMultiEvent(wxEventType EventType=wxEVT_NULL, wxTreeMultiItem const& InitItem=wxTreeMultiItem());

 // inherited functions:
  // wxEvent:
   // cloning:
    virtual wxEvent* Clone() const {return new wxTreeMultiEvent(*this);}

 // item handling:
  wxTreeMultiItem GetItem(void) const
  {
    return this->m_Item;
  }
  void SetItem(wxTreeMultiItem const& NewItem)
  {
    this->m_Item = NewItem;
  }
  
 // old item handling:
  wxTreeMultiItem GetOldItem(void) const
  {
    return this->m_OldItem;
  }
  void SetOldItem(wxTreeMultiItem const& NewItem)
  {
    this->m_OldItem = NewItem;
  }
  
protected:
private:
 // variables:
  wxTreeMultiItem m_Item, m_OldItem;
  
 // class identification:
  DECLARE_DYNAMIC_CLASS(wxTreeMultiEvent)
};


// event handler function:
typedef void (wxEvtHandler::*wxTreeMultiEventFunction)(wxTreeMultiEvent&);

// event types:
BEGIN_DECLARE_EVENT_TYPES()
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_BEGIN_DRAG,        -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_BEGIN_RDRAG,       -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_BEGIN_LABEL_EDIT,  -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_END_LABEL_EDIT,    -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_DELETE_ITEM,       -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_GET_INFO,          -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_SET_INFO,          -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_EXPANDED,     -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_EXPANDING,    -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_COLLAPSED,    -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_COLLAPSING,   -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_SEL_CHANGED,       -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_SEL_CHANGING,      -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_KEY_DOWN,          -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_ACTIVATED,    -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_RIGHT_CLICK,  -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_MIDDLE_CLICK, -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_END_DRAG,          -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_STATE_IMAGE_CLICK, -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_GETTOOLTIP,   -1)
    DECLARE_EVENT_TYPE(wxEVT_COMMAND_TREE_MULTI_ITEM_MENU,         -1)
END_DECLARE_EVENT_TYPES()

#define wxTreeMultiEventHandler(func) (wxObjectEventFunction)(wxEventFunction) wxStaticCastEvent(wxTreeMultiEventFunction, &func)


// standard events similar or identical to wxTreeEvent:
#define EVT_TREE_MULTI_BEGIN_DRAG (id,fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_BEGIN_DRAG, id,wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_BEGIN_RDRAG(id,fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_BEGIN_RDRAG,id,wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_END_DRAG   (id,fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_END_DRAG,   id,wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_BEGIN_LABEL_EDIT(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_BEGIN_LABEL_EDIT, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_END_LABEL_EDIT(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_END_LABEL_EDIT, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_GET_INFO(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_GET_INFO, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_SET_INFO(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_SET_INFO, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_ITEM_EXPANDED(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_MULTI_ITEM_EXPANDED, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_ITEM_EXPANDING(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_MULTI_ITEM_EXPANDING, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_ITEM_COLLAPSED(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_MULTI_ITEM_COLLAPSED, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_ITEM_COLLAPSING(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_MULTI_ITEM_COLLAPSING, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_SEL_CHANGED(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_SEL_CHANGED, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_SEL_CHANGING(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_SEL_CHANGING, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_KEY_DOWN(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_KEY_DOWN, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_DELETE_ITEM(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_DELETE_ITEM, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_ITEM_ACTIVATED(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_MULTI_ITEM_ACTIVATED, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_ITEM_MENU(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_MULTI_ITEM_MENU, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_ITEM_RIGHT_CLICK(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_MULTI_ITEM_RIGHT_CLICK, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_ITEM_MIDDLE_CLICK(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_MULTI_ITEM_MIDDLE_CLICK, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_STATE_IMAGE_CLICK(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_STATE_IMAGE_CLICK, id, wxTreeMultiEventHandler(fn))
#define EVT_TREE_MULTI_ITEM_GETTOOLTIP(id, fn) wx__DECLARE_EVT1(wxEVT_COMMAND_TREE_MULTI_ITEM_GETTOOLTIP, id, wxTreeMultiEventHandler(fn))

#endif
