/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la SantÈ)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
# Previous Authors : Laurent Guigues, Jean-Pierre Roux
# CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------ */



/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkAtomicBlackBox.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.14 $
=========================================================================*/



/**
 *  \file 
 *  \brief class bbtk::AtomicBlackBox : abstract user defined black boxes
 */
#include "bbtkAtomicBlackBox.h"

namespace bbtk
{
  
  //=========================================================================
  AtomicBlackBox::AtomicBlackBox(const std::string &name, bool alloc)
    : BlackBox(name)
  {
    bbtkBlackBoxDebugMessage("object",3,
		     "==> AtomicBlackBox(\""
		     <<name<<"\")"<<std::endl);
  }
  //========================================================================= 
  
  //=========================================================================
  /// Constructor from an existing box (copy) with a new name 
  AtomicBlackBox::AtomicBlackBox(AtomicBlackBox& from, 
                const std::string &name, 
                bool alloc)
    : BlackBox(from,name)
  {
    bbtkBlackBoxDebugMessage("object",3,
			     "==> AtomicBlackBox("
			     <<from.bbGetFullName()<<",\""
			     <<name<<"\")"<<std::endl);
  }
  //=========================================================================
  
  
  //=========================================================================
  ///  Destructor
  AtomicBlackBox::~AtomicBlackBox()
  {
    bbtkBlackBoxDebugMessage("object",3,"==> ~AtomicBlackBox()"
		     <<std::endl);
    bbtkBlackBoxDebugMessage("object",3,"<== ~AtomicBlackBox()"
		     <<std::endl);
  } 
  //=========================================================================
  


  
  //=========================================================================
  Data AtomicBlackBox::bbGetOutput( const std::string &name )
  {
    bbtkBlackBoxDebugMessage("data",7,
			     "AtomicBlackBox::bbGetOutput(\""<<name<<"\")"
			     <<std::endl);
    
    Data p = ((AtomicBlackBoxOutputDescriptor*)bbGetDescriptor()
	      ->GetOutputDescriptor(name))->GetGetFunctor()->Get(this);
    
    return p;
  }
  //=========================================================================
  
  
  //=========================================================================
  ///  Gets the input Data of a given name
  Data AtomicBlackBox::bbGetInput( const std::string &name ) 
  {
    bbtkBlackBoxDebugMessage("data",7,
			     "AtomicBlackBox::bbGetInput(\""<<name<<"\")"
			     <<std::endl);  
    
    Data p = ((AtomicBlackBoxInputDescriptor*)bbGetDescriptor()
	      ->GetInputDescriptor(name))->GetGetFunctor()->Get(this);
    
    return p;
  }
  //=========================================================================
  
  
  //=========================================================================
  ///  Sets the data of the output called <name>
  void AtomicBlackBox::bbSetOutput( const std::string &name, Data data)
  {
    bbtkBlackBoxDebugMessage("data",7,
            "AtomicBlackBox::bbSetOutput(\""<<name<<"\",data)"
            <<std::endl); 
    
    ((AtomicBlackBoxOutputDescriptor*)bbGetDescriptor()
        ->GetOutputDescriptor(name))->GetSetFunctor()->Set(this,data);
    
    bbtkDebugDecTab("Data",7);
  }  
  //=========================================================================
  
  
  //=========================================================================
  ///  Sets the data of the input called <name>
  void AtomicBlackBox::bbSetInput(const std::string &name,
				  Data data, 
				  bool setModified )
  {
    bbtkBlackBoxDebugMessage("data",7,
            "AtomicBlackBox::bbSetInput(\""<<name<<"\",data)"
            <<std::endl);  
    ((AtomicBlackBoxInputDescriptor*)bbGetDescriptor()->GetInputDescriptor(name))->GetSetFunctor()->Set(this,data);
    
    if (setModified) 
      {
	bbSetStatusAndPropagate(bbGetInputConnectorMap().find(name)->second,
				MODIFIED);
      }
    
  }
  //=========================================================================
  
  //=========================================================================
  ///  Sets the data of the input called <name>
  void AtomicBlackBox::bbBruteForceSetInputPointer(const std::string &name, 
						   void* data, 
						   bool setModified
						   )
  {
    bbtkBlackBoxDebugMessage("data",7,
            "AtomicBlackBox::bbBruteForceSetInputPointer(\""
            <<name<<"\",data)"
            <<std::endl);  
    ((AtomicBlackBoxInputDescriptor*)bbGetDescriptor()
        ->GetInputDescriptor(name))->GetSetFunctor()
            ->BruteForceSetPointer(this,data);
    
    if (setModified) 
      {
	bbSetStatusAndPropagate(bbGetInputConnectorMap().find(name)->second,
				MODIFIED);
      }
    
  }
  //=========================================================================
 


  //==========================================================================
  std::string AtomicBlackBox::GetObjectInfo() const 
  {
    std::stringstream i;
    return i.str();
  }
  //==========================================================================

  //==========================================================================
  size_t AtomicBlackBox::GetObjectSize() const 
  {
    return sizeof(*this);
  }
  //==========================================================================
  
  //==========================================================================
  size_t AtomicBlackBox::GetObjectRecursiveSize() const 
  {
    size_t s = GetObjectSize();
    return s;
  }
  //==========================================================================

 
}
// EO namespace bbtk
