/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkAtomicBlackBoxDescriptor.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.6 $
=========================================================================*/

#include "bbtkAtomicBlackBoxDescriptor.h"
#include "bbtkBlackBox.h"
#include "bbtkPackage.h"
#define bbtkDMessage(key,level,mess) \
  bbtkMessage(key,level,"["<<GetFullTypeName()<<"] "<<mess)
#define bbtkDDebugMessage(key,level,mess)	\
  bbtkDebugMessage(key,level,"["<<GetFullTypeName()<<"] "<<mess)

namespace bbtk
{
  AtomicBlackBoxDescriptor::AtomicBlackBoxDescriptor() 
  {  
    bbtkDDebugMessage("object",3,"==> AtomicBlackBoxDescriptor()"<<std::endl);
    // Creates the input 'BoxProcessMode'
    AddInputDescriptor
      (new 
       bbtk::AtomicBlackBoxInputDescriptor
       (typeid(AtomicBlackBoxDescriptor),
	"BoxProcessMode",
	"Sets the processing mode of the box (Pipeline | Always | Reactive | Manual)",
	"",
	new bbtk::AtomicBlackBoxTGetFunctor<BlackBox,std::string,std::string>(&BlackBox::bbGetInputBoxProcessMode), 
	new bbtk::AtomicBlackBoxTSetFunctor<BlackBox,std::string,std::string>(&BlackBox::bbSetInputBoxProcessMode) ) );
    // Creates the input 'BoxExecute'
    AddInputDescriptor
      (new
       bbtk::AtomicBlackBoxInputDescriptor
       (typeid(AtomicBlackBoxDescriptor),
	"BoxExecute",
	"Any signal received by this input executes the box",
	"signal",
	new bbtk::AtomicBlackBoxTGetFunctor<BlackBox,Void,Void>(&BlackBox::bbGetInputBoxExecute), 
	new bbtk::AtomicBlackBoxTSetFunctor<BlackBox,Void,Void>(&BlackBox::bbSetInputBoxExecute) ) );
    // Creates the output 'BoxChange'      
    AddOutputDescriptor
      (new 
       bbtk::AtomicBlackBoxOutputDescriptor
       (typeid(AtomicBlackBoxDescriptor),
	"BoxChange",
	"Signals modifications of the box", 
	"signal",
	new bbtk::AtomicBlackBoxTGetFunctor<BlackBox,Void,Void>(&BlackBox::bbGetOutputBoxChange), 
	new bbtk::AtomicBlackBoxTSetFunctor<BlackBox,Void,Void>(&BlackBox::bbSetOutputBoxChange) ) );
    //
    AddToCategory("atomic box");
    bbtkDDebugMessage("object",3,"<== AtomicBlackBoxDescriptor()"<<std::endl);
  }
  //===================================================================

  AtomicBlackBoxDescriptor::~AtomicBlackBoxDescriptor() 
  {  
    bbtkDDebugMessage("object",3,"==> ~AtomicBlackBoxDescriptor()"<<std::endl);
  }

  	
}// namespace bbtk
