/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkAtomicBlackBoxInputDescriptor.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.5 $
=========================================================================*/
                                                                      

/**
 *  \file 
 *  \brief Class bbtk::AtomicBlackBoxInputDescriptor : structure containing the description of a AtomicBlackBox input (name, description, type, functor)
 */
#include "bbtkAtomicBlackBoxInputDescriptor.h"


namespace bbtk
{
  
  AtomicBlackBoxInputDescriptor::
  AtomicBlackBoxInputDescriptor( TypeInfo creator_type_info,
				 const std::string& name,
				 const std::string& description,
				 const std::string& nature,
				 AtomicBlackBoxGetFunctor* getfunctor,
				 AtomicBlackBoxSetFunctor* setfunctor,
				 bool copy_construct) 
    : 
    BlackBoxInputDescriptor(creator_type_info,
			    name,description,
			    nature,
			    copy_construct,
			    MANDATORY),
    mGetFunctor(getfunctor),
    mSetFunctor(setfunctor)
  {  
    bbtkDebugMessage("kernel",9,
		     "AtomicBlackBoxInputDescriptor(\""
		     <<name<<"\",\""<<description<<"\",\""
		     <<nature<<"\","
		     <<getfunctor<<","<<setfunctor<<","
		     <<copy_construct<<")"<<std::endl);
  }



  AtomicBlackBoxInputDescriptor::~AtomicBlackBoxInputDescriptor()
  {
    bbtkDebugMessage("kernel",9,
		     "~AtomicBlackBoxInputDescriptor(\""
		     <<GetName()<<"\")"<<std::endl);
  } 
}
