/*
# ---------------------------------------------------------------------
#
# Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
#                        pour la Santé)
# Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
#
#  This software is governed by the CeCILL-B license under French law and
#  abiding by the rules of distribution of free software. You can  use,
#  modify and/ or redistribute the software under the terms of the CeCILL-B
#  license as circulated by CEA, CNRS and INRIA at the following URL
#  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
#  or in the file LICENSE.txt.
#
#  As a counterpart to the access to the source code and  rights to copy,
#  modify and redistribute granted by the license, users are provided only
#  with a limited warranty  and the software's author,  the holder of the
#  economic rights,  and the successive licensors  have only  limited
#  liability.
#
#  The fact that you are presently reading this means that you have had
#  knowledge of the CeCILL-B license and that you accept its terms.
# ------------------------------------------------------------------------
 */

/*=========================================================================
Program:   bbtk
Module:    $RCSfile$
Language:  C++
Date:      $Date$
Version:   $Revision$
=========================================================================*/


/**
 *  \file
 *  \brief Class bbtk::BBPInterpreter
 */


#include "bbtkBBPInterpreter.h"

#include "bbtkExecuter.h"
#include "bbtkMessageManager.h"
#include "bbtkFactory.h"
#include "bbtkUtilities.h"

namespace bbtk
{

  //=========================================================================
  BBPInterpreter::Pointer BBPInterpreter::New()
  {
    return MakePointer( new BBPInterpreter() );
  }
  //=========================================================================



  //=========================================================================
  BBPInterpreter::BBPInterpreter()
  {
    bbtk::InterpreterVirtual::Init();
  }
  //=========================================================================


  //=========================================================================
  BBPInterpreter::~BBPInterpreter()
  {
  }
  //=========================================================================


  //=========================================================================
  /// Creates a new black box in current complex box
  void BBPInterpreter::commandNew( const std::string& boxType, const std::string& boxName) // virtual
  {
    this->dependencies.insert(boxType);
  }
  //=========================================================================


  //=========================================================================
  /// Connects the output boxOutput to the input boxInput
  void BBPInterpreter::commandConnection (const std::string &boxfrom,
      const std::string &output,
      const std::string &boxto,
      const std::string &input)			// virtual
  {
  }
  //=========================================================================

  //=========================================================================
  void BBPInterpreter::commandInput(const std::string &name,const std::string &box,const std::string &input,const std::string  &help)
  {
  }
  //=========================================================================

  //=========================================================================
  void BBPInterpreter::commandOutput(const std::string &name,const std::string &box,const std::string &output,const std::string  &help)
  {
  }
  //=========================================================================


  //=========================================================================
  /// sets the input of the box with the value
  void BBPInterpreter::commandSet(const std::string &box,const std::string &input,const std::string &value) // virtual
  {
  }
  //=========================================================================


  //=========================================================================
  void BBPInterpreter::commandDefine(const std::string &name,const std::string &pack,const std::string &scriptfilename) // virtual
  {
    this->boxName = name;
  }
  //=========================================================================


  //=========================================================================
  void BBPInterpreter::commandEndDefine() // virtual
  {
  }
  //=========================================================================


  //=========================================================================
  void BBPInterpreter::commandExec(const std::string &word) // virtual
  {
  }
  //=========================================================================


  //=========================================================================
  void BBPInterpreter::commandAuthor(const std::string &author)  // virtual
  {
  }
  //=========================================================================

  //=========================================================================
  void BBPInterpreter::commandCategory(const std::string &categorytype)  // virtual
  {
  }
  //=========================================================================

  //=========================================================================
  void BBPInterpreter::commandDescription(const std::string &description)  // virtual
  {
  }
  //=========================================================================

}  // EO namespace bbtk

// EOF

