/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkBlackBoxInputConnector.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.12 $
=========================================================================*/


/**
 *  \file 
 *  \brief Class bbtk::BlackBoxInputConnector : 
 */
#include "bbtkBlackBoxInputConnector.h"
#include "bbtkMessageManager.h"
#include "bbtkBlackBox.h"

namespace bbtk
{

  //========================================================================
  /// The Pimpl
  class BlackBoxInputConnector::Pimpl
  {
  public:
    Pimpl() : mConnection(0), mStatus(MODIFIED) {}
      
    /// 
    BlackBoxWeakPointer mBox;
    /// The connection plugged into the input
    Connection* mConnection;
    /// The status of the input (UPTODATE | MODIFIED | OUTOFDATE)
    IOStatus mStatus;

  };
  //========================================================================

  //========================================================================
  BBTK_IMPL_PIMPL(BlackBoxInputConnector)
  //========================================================================


  //========================================================================
  BlackBoxInputConnector::BlackBoxInputConnector(BlackBox::Pointer b)  
  //: mBox(b), mConnection(0), mStatus(MODIFIED)
  {
    bbtkDebugMessage("kernel",9,
		     "["<<b->bbGetName()
		     <<"] BlackBoxInputConnector()"<<std::endl);
    PimplConstruct();
    p->mBox = b;
  }
  //========================================================================

  //========================================================================
  BlackBoxInputConnector::~BlackBoxInputConnector() 
  {
    bbtkDebugMessage("kernel",9,
		     "[DEAD BOX] ~BlackBoxInputConnector()"
		     <<std::endl);
    PimplDestruct();
  }
  //========================================================================

  //========================================================================
  /// Returns the connection plugged into this input (const)
  Connection* BlackBoxInputConnector::GetConnection() const 
  { 
    return p->mConnection; 
  }
  //========================================================================
  

  //========================================================================
  /// Returns true iff a connection is connected to it
    bool BlackBoxInputConnector::IsConnected() const 
  { 
    return (p->mConnection != 0); 
  }
   //========================================================================
   

   //========================================================================
   /// Returns the status of the input 
    IOStatus BlackBoxInputConnector::GetStatus() const 
   { 
     return p->mStatus; 
   }
  //========================================================================

  //========================================================================
    /// Sets the status of the input 
    void BlackBoxInputConnector::SetStatus(IOStatus s) 
    { 
      p->mStatus = s; 
    }
   //========================================================================
   
    

  //========================================================================
    /// Returns the black box which owns the connector
    BlackBoxPointer BlackBoxInputConnector::GetBlackBox() const 
    { 
      return p->mBox.lock(); 
    } 

  //========================================================================

  //========================================================================
  void BlackBoxInputConnector::SetConnection(Connection* c) 
  { 
    bbtkDebugMessage("kernel",9,
		     "["<<p->mBox.lock()->bbGetName()
		     <<"] BlackBoxInputConnector::SetConnection("<<c<<")"<<std::endl);
    p->mConnection = c; 
  }
  //========================================================================

  //========================================================================
  void BlackBoxInputConnector::UnsetConnection(Connection* c) 
  { 
    bbtkDebugMessage("kernel",9,
		     "["<<p->mBox.lock()->bbGetName()
		     <<"] BlackBoxInputConnector::UnsetConnection("
		     <<c<<")"<<std::endl);
    p->mConnection = 0; 
  }
  //========================================================================
  
  //========================================================================
  void BlackBoxInputConnector::RecursiveExecute()
  {
    // If connected and OUTOFDATE : recursive update
    // Post-update status is updated by the connection 
    // (either MODIFIED or OUTOFDATE)
    if ( p->mConnection && (p->mStatus == OUTOFDATE) )
      {
	p->mConnection->RecursiveExecute();
      }
    else
      {
	if (!p->mBox.expired())
	  bbtkDebugMessage("process",5,"["<<p->mBox.lock()->bbGetName()
			   <<"] --> BlackBoxInputConnector::RecursiveExecute() : "
			   <<"No connection or input not Out-of-date : nothing to do"
			   <<std::endl);
	else
	  bbtkDebugMessage("process",5,
			   "[DEAD BOX] --> BlackBoxInputConnector::RecursiveExecute() : "
			   <<"No connection or input not Out-of-date : nothing to do"
			   <<std::endl);
	  
      }
  }
  //========================================================================

}
// namespace bbtk

