/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkBlackBoxOutputConnector.cxx,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.14 $
=========================================================================*/


/**
 *  \file 
 *  \brief Class bbtk::BlackBoxOutputConnector : 
 */

#include "bbtkBlackBoxOutputConnector.h"
#include "bbtkMessageManager.h"
#include "bbtkBlackBox.h"
//#include <algorithm>

namespace bbtk
{

  //========================================================================
  /// The Pimpl
  class BlackBoxOutputConnector::Pimpl
  {
  public:
    Pimpl() : mStatus(OUTOFDATE) {}
    Pimpl(const Pimpl&) {}
   /// 
    BlackBoxWeakPointer mBox;
    /// The vector of output connections
    ConnectionVector mConnection;
    /// The status of the output 
    IOStatus mStatus;
    /// The output changed signal 
    BlackBox::OutputChangeSignalType mChangeSignal;


  };
  //========================================================================

  //========================================================================
  BBTK_IMPL_PIMPL(BlackBoxOutputConnector)
  //========================================================================


  //======================================================================
  BlackBoxOutputConnector::BlackBoxOutputConnector(BlackBox::Pointer b) 
  {
    bbtkDebugMessage("kernel",9,
		     "["<<b->bbGetName()
		     <<"] BlackBoxOutputConnector()"<<std::endl);
    PimplConstruct();
    p->mBox = b;
  }
  //======================================================================


  //======================================================================
  BlackBoxOutputConnector::~BlackBoxOutputConnector() 
  {
    bbtkDebugMessage("kernel",9,
		     "[DEAD BOX] ==> ~BlackBoxOutputConnector()"
		     <<std::endl);
    /*
    ConnectionVector::iterator i;
    for (i=mConnection.begin();
	 i!=mConnection.end();
	 ++i)
      (*i) = Connection::WeakPointer();
    */
    p->mConnection.clear();
    PimplDestruct();
  
    bbtkDebugMessage("kernel",9,
		     "[DEAD BOX] <== ~BlackBoxOutputConnector()"
		     <<std::endl);
  }
  //======================================================================

  //======================================================================
  ///
  void BlackBoxOutputConnector::SetConnection(Connection* c)
  {
    bbtkDebugMessage("kernel",9,
		     "["<<p->mBox.lock()->bbGetName()
		     <<"] BlackBoxOutputConnector::SetConnection("
		     <<c<<")"<<std::endl);
    p->mConnection.push_back(c);
    //    AddChangeObserver(boost::bind(&Connection::SignalChange,c));
  }
  //======================================================================


  //======================================================================
  void BlackBoxOutputConnector::UnsetConnection(Connection* c)
  {
    bbtkDebugMessage("kernel",9,"["<<p->mBox.lock()->bbGetName()
		     <<"] BlackBoxOutputConnector::UnsetConnection("
		     <<c<<")"<<std::endl);

    if (!c) 
      {
	bbtkInternalError(p->mBox.lock()->bbGetFullName()
			  <<": BlackBoxOutputConnector::UnsetConnection("
			  <<c<<") : invalid connection");

      }
    //    c->Check();
    //Connection::WeakPointer w(c);
    ConnectionVector::iterator i;
    //  = find(mConnection.begin(),mConnection.end(),c);
    for (i=p->mConnection.begin();
	 i!=p->mConnection.end();
	 ++i)
      {
	if (*i==c) break;
      }
    if (i==p->mConnection.end())
      {
	bbtkInternalError(p->mBox.lock()->bbGetFullName()
			  <<": BlackBoxOutputConnector::UnsetConnection("
			  <<c
			  <<") : connection is absent from connections list");
      }
    p->mConnection.erase(i);
    //    RemoveChangeObserver(boost::bind(&Connection::SignalChange,c));


  }
  //======================================================================
  
  //======================================================================
  const BlackBoxOutputConnector::ConnectionVector& 
  BlackBoxOutputConnector::GetConnectionVector() const
  { 
    return p->mConnection; 
  }
  //======================================================================
  
  //======================================================================
  /// Returns the status of the input 
  IOStatus BlackBoxOutputConnector::GetStatus() const 
  { 
    return p->mStatus; 
  }
  //======================================================================

  //======================================================================
  /// Sets the status of the input 
  void BlackBoxOutputConnector::SetStatus( IOStatus s ) 
  {
    p->mStatus = s; 
  }
  //======================================================================
  
  //======================================================================
  void BlackBoxOutputConnector::SignalChange( BlackBox::Pointer box,
					      const std::string& output )
  {
    IOStatus s = OUTOFDATE; //mStatus;
    //if (s==UPTODATE) s=MODIFIED;
    
    bbtkDebugMessage("change",2,
		     "["<<box->bbGetName()
		     <<"] ==> BlackBoxOutputConnector::SignalChange('"
		     <<output<<"','"<<GetIOStatusString(s)<<"') ["
		     <<this<<"]"
		     <<std::endl);
    
    //    std::cout<<"BlackBoxOutputConnector::SignalChange("
    //	     <<box->bbGetName()<<",'"
    //	     <<output<<"')"<<std::endl;
    p->mChangeSignal(box,output,s);
    
    bbtkDebugMessage("change",2,
		     "["<<box->bbGetName()
		     <<"] <== BlackBoxOutputConnector::SignalChange('"
		     <<output<<"','"<<GetIOStatusString(s)<<"') ["
		     <<this<<"]"
		     <<std::endl);
  }
  //======================================================================

  //======================================================================
  void BlackBoxOutputConnector::AddChangeObserver(OutputChangeCallbackType f)
  { 
    //    std::cout << "BlackBoxOutputConnector::AddChangeObserver" << std::endl;
    p->mChangeSignal.connect(f); 
  }
  //======================================================================
  
  //======================================================================
  /// Removes the function f from the list of functions to call when 
  /// the output changes (TO WRITE)
  void BlackBoxOutputConnector::RemoveChangeObserver(OutputChangeCallbackType f)
  { 
    bbtkError("BlackBoxOutputConnector::RemoveChangeObserver not implemented");
    
    //mChangeSignal.disconnect(f);
  }
  //======================================================================
}
// namespace bbtk

