/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkComplexBlackBoxInputDescriptor.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.5 $
=========================================================================*/


/**
 *  \file 
 *  \brief Class bbtk::ComplexBlackBoxInputDescriptor : structure containing the description of a ComplexBlackBox input (name, description, type, mapping)
 */
/**
 * \class bbtk::ComplexBlackBoxInputDescriptor
 * \brief Structure containing the description of a ComplexBlackBox input (name, description, type, mapping)
 */

#ifndef __bbtkComplexBlackBoxInputDescriptor_h__
#define __bbtkComplexBlackBoxInputDescriptor_h__

#include "bbtkBlackBoxInputDescriptor.h"
#include "bbtkMessageManager.h"

namespace bbtk
{


  class BBTK_EXPORT ComplexBlackBoxInputDescriptor : 
    public bbtk::BlackBoxInputDescriptor
  {
  public:
      
    ComplexBlackBoxInputDescriptor( TypeInfo creator_type_info,
				    const std::string& name,
				    const std::string& description,
				    const std::string& nature,
				    const std::string& target,
				    const std::string& input,
				    TypeInfo type);
    
    ~ComplexBlackBoxInputDescriptor();
    
    /// Returns the type of the input
    TypeInfo GetTypeInfo() const { return mType; }
    /// Returns the name of the type of the input
    std::string GetTypeName() const { return TypeName(mType); }
    /// Returns the name of the type of the input
    std::string GetHumanTypeName() const { return HumanTypeName(mType); }
    /// Returns the target black box 
    const std::string& GetTarget() const { return mTarget; }
    /// Returns the input 
    const std::string& GetInput() const { return mInput; }
    /// 
    bool IsPointerType() const { return false; }
    
    
  private:
    /// Default ctor is private 
    ComplexBlackBoxInputDescriptor() : 
      BlackBoxInputDescriptor(typeid(void),"","",""),
      mType(typeid(void)) {}
    std::string mTarget;
    std::string mInput;
    TypeInfo mType;
  };

  
}
// namespace bbtk
#endif
