/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkConfigurationFile.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.13 $
=========================================================================*/

                                                                       

/**
 *\file
 *\brief Class bbtk::ConfigurationFile
 */
/**
 *\class bbtk::ConfigurationFile
 *\brief DDD
 *
 */

#ifndef __bbtkConfigurationFile_h__
#define __bbtkConfigurationFile_h__

#include "bbtkSystem.h"
#include <string>


#ifdef WIN32
  #if __VISUALC__ < 1400
	#define _CRT_SECURE_NO_DEPRECATE
  #endif
#endif

#include <stdio.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>



namespace bbtk
{
  //==========================================================================
  class BBTK_EXPORT  ConfigurationException
  {
  public:
    ConfigurationException(const std::string& message) : mMessage(message) {}
    
    std::string mMessage;
  };
  //==========================================================================
  
  //==========================================================================
  class BBTK_EXPORT ConfigurationFile
  {
  public:
    
    static ConfigurationFile& GetInstance()
    {
      static ConfigurationFile f;
      return f;
    }
    
    ~ConfigurationFile();
    
    void GetHelp(int level) const;

    /// Returns true iff the directory .bbtk has been created on construction
    inline bool DotBbtkIsNew() { return mDot_bbtk_is_new; }

    inline const std::string& Get_description() const
    { return mDescription;}

    inline const std::string& Get_data_path() const
    { return mData_path;}  
    inline const std::string& Get_file_separator() const
	{ return mFile_separator;}
    
    inline const std::string& Get_dot_bbtk_path() const
    { return mDot_bbtk_path;}
    inline const std::string& Get_bin_path() const
    { return mBin_path;}
    inline const std::string& Get_install_path() const
    { return mInstall_path;}
    inline const std::string& Get_doc_path() const
    { return mDoc_path;}
      
    inline const std::string& Get_root_bbs_path() const
    { return mBbs_path;}
    inline const std::vector<std::string>& Get_bbs_paths() const
    { return mBbs_paths;}
    inline const std::vector<std::string>& Get_package_paths() const
    { return mPackage_paths;}
    inline const std::string& Get_config_xml_full_path() const
    { return mConfig_xml_full_path;}
    inline const std::string& Get_default_temp_dir() const
    { return mTemp_path;}

    bool AddPackagePathsAndWrite( const std::string& package_root_path );
    
  private:
    ConfigurationFile();
    void InstallPath ();
    void Read(const std::string& fileName);
    void CreateConfigXML( char *rootDirectory );
    void InitializeDotBbtkStructure();
    // Attributes :
  private :
    std::string mDescription; 
    /// Where is the file bbtk_config.xml
    std::string mConfig_xml_full_path;  
    
    /// Set automatically :
    /// The path to the executable (usually bbi)
    std::string mBin_path;
    /// The path to the .bbtk user's dir (e.g. /home/username/.bbtk)
    std::string mDot_bbtk_path;
    /// The path to the install prefix (=mBinPath+"/..")
    std::string mInstall_path;
    /// The path to the doc folder (=mDot_bbtk_path+"/doc")
    std::string mDoc_path;
    /// Temp directory for generated data (=mDot_bbtk_path+"/tmp")
    std::string mTemp_path;      
    /// The relative path to the doc folder (=BBTK_BBS_REL_PATH)
    std::string mBbs_rel_path;
    /// The path to the bbs folder (=mInstall_path+"/"+mBbs_rel_path)
    std::string mBbs_path;
    /// The path to the bbtk data folder 
    /// Initialized to mInstall_path+"/"+BBTK_DATA_REL_PATH
    /// But can be overriden by value read from bbtk_config.xml
    std::string mData_path;
    
    /// / or \, depending on the OS
    std::string mFile_separator;
    
    /// Read from bbtk_config.xml file
    /// Where the doc is
    std::string mUrl;
    /// Scripts  
    std::vector<std::string> mBbs_paths; 
    /// Package dlls    
    std::vector<std::string> mPackage_paths;
    /// If Packages link against extern dlls
    std::vector<std::string> mExt_dll_paths;


    /// Set to true by InitializeDotBbtkStructure() if .bbtk has been newly
    /// created
    bool mDot_bbtk_is_new;
   };
  
  
}// namespace bbtk



#endif

