/*
 # ---------------------------------------------------------------------
 #
 # Copyright (c) CREATIS (Centre de Recherche en Acquisition et Traitement de l'Image
 #                        pour la SantÈ)
 # Authors : Eduardo Davila, Frederic Cervenansky, Claire Mouton
 # Previous Authors : Laurent Guigues, Jean-Pierre Roux
 # CreaTools website : www.creatis.insa-lyon.fr/site/fr/creatools_accueil
 #
 #  This software is governed by the CeCILL-B license under French law and
 #  abiding by the rules of distribution of free software. You can  use,
 #  modify and/ or redistribute the software under the terms of the CeCILL-B
 #  license as circulated by CEA, CNRS and INRIA at the following URL
 #  http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 #  or in the file LICENSE.txt.
 #
 #  As a counterpart to the access to the source code and  rights to copy,
 #  modify and redistribute granted by the license, users are provided only
 #  with a limited warranty  and the software's author,  the holder of the
 #  economic rights,  and the successive licensors  have only  limited
 #  liability.
 #
 #  The fact that you are presently reading this means that you have had
 #  knowledge of the CeCILL-B license and that you accept its terms.
 # ------------------------------------------------------------------------ */


/*=========================================================================
  Program:   bbtk
  Module:    $RCSfile: bbtkDynamicLibraryHandling.h,v $
  Language:  C++
  Date:      $Date: 2012/11/16 08:49:01 $
  Version:   $Revision: 1.3 $
=========================================================================*/

                                                                       

/**
 *\file
 *\brief Dynamic library loading stuff (OS dependent)
 */

// System dependent includes for loading dynamic libraries
#if defined(__GNUC__)
// GCC compiler

// dlopen, dlsym, etc.
#include <dlfcn.h>

// dlopen loading mode : 
// instant/delayed symbol resolution
#ifndef BBTK_RTLD_NOW
#  define BBTK_RTLD_TIME RTLD_LAZY
#else
#  define BBTK_RTLD_TIME RTLD_NOW
#endif
// local/global symbol loading
// one **MUST** use RTLD_GLOBAL in order to have 
// the RTTI mechanism travel correctly across packages (typeid,dynamic_cast...)
// however this can cause problems (symbol clashes) ...
// see :
// http://gcc.gnu.org/faq.html#dso
// http://gcc.gnu.org/ml/gcc/2003-04/msg00256.html
// http://gcc.gnu.org/ml/gcc-bugs/2003-10/msg02771.html
#ifndef BBTK_RTLD_LOCAL
#  define BBTK_RTLD_SCOPE RTLD_GLOBAL
#else 
#  define BBTK_RTLD_SCOPE RTLD_LOCAL
#endif

// dl handler type
namespace bbtk 
{
  typedef void* DynamicLibraryHandler;
}

#elif defined(_WIN32)
// Win32
// HINSTANCE, LoadLibrary, etc. definition
#include "Windows.h"
// dl handler type
namespace bbtk 
{
  typedef HINSTANCE DynamicLibraryHandler;
}

#else

ERROR !! DYNAMIC LIBRARY LOADING NOT IMPLEMENTED FOR YOUR SYSTEM

#endif
